/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.CompilationErrorException;
import org.jetbrains.kotlin.ir.linkage.IrProvider;
import org.jetbrains.kotlin.ir.linkage.KotlinIrLinkerInternalException;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGeneratorKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/util/ExternalDependenciesGenerator;", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irProviders", "", "Lorg/jetbrains/kotlin/ir/linkage/IrProvider;", "(Lorg/jetbrains/kotlin/ir/util/SymbolTable;Ljava/util/List;)V", "getSymbolTable", "()Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "generateUnboundSymbolsAsDependencies", "", "ir.tree"})
public final class ExternalDependenciesGenerator {
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final List<IrProvider> irProviders;

    public ExternalDependenciesGenerator(@NotNull SymbolTable symbolTable, @NotNull List<? extends IrProvider> irProviders) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(irProviders, "irProviders");
        this.symbolTable = symbolTable;
        this.irProviders = irProviders;
    }

    @NotNull
    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateUnboundSymbolsAsDependencies() {
        Object object;
        block7: {
            void var4_6;
            Iterable $this$singleOrNull$iv = this.irProviders;
            boolean $i$f$singleOrNull = false;
            Object var4_5 = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrProvider it = (IrProvider)element$iv;
                boolean bl = false;
                if (!(it instanceof DeclarationStubGenerator)) continue;
                if (found$iv) {
                    object = null;
                    break block7;
                }
                Object t = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var4_6;
        }
        IrProvider irProvider = (IrProvider)object;
        if (irProvider != null) {
            IrProvider it = irProvider;
            boolean bl = false;
            ((DeclarationStubGenerator)it).setUnboundSymbolGeneration(true);
        }
        try {
            Set prevUnbound;
            Set<Object> unbound = SetsKt.emptySet();
            do {
                prevUnbound = unbound;
                unbound = SymbolTableKt.getAllUnbound(this.symbolTable);
                for (IrSymbol irSymbol2 : unbound) {
                    if (irSymbol2.isBound()) continue;
                    ExternalDependenciesGeneratorKt.getDeclaration(this.irProviders, irSymbol2);
                }
            } while (!Intrinsics.areEqual(unbound, prevUnbound));
        }
        catch (KotlinIrLinkerInternalException ex) {
            throw new CompilationErrorException();
        }
    }
}

