/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.CharMatcher;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ValidationException;

public final class BugPatternValidator {
    public static void validate(BugPattern pattern) throws ValidationException {
        if (pattern == null) {
            throw new ValidationException("No @BugPattern provided");
        }
        if (CharMatcher.whitespace().matchesAnyOf(pattern.name())) {
            throw new ValidationException("Name must not contain whitespace: " + pattern.name());
        }
        switch (pattern.linkType()) {
            case CUSTOM: {
                if (!pattern.link().isEmpty()) break;
                throw new ValidationException("Expected a custom link but none was provided");
            }
            case AUTOGENERATED: 
            case NONE: {
                if (pattern.link().isEmpty()) break;
                throw new ValidationException("Expected no custom link but found: " + pattern.link());
            }
        }
    }

    private BugPatternValidator() {
    }
}

