/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Pair;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@Immutable
@CheckReturnValue
public class SuppressionInfo {
    public static final SuppressionInfo EMPTY = new SuppressionInfo(ImmutableSet.of(), ImmutableSet.of(), false);
    private static final Supplier<Name> ANDROID_SUPPRESS_LINT = VisitorState.memoize(state -> state.getName("android.annotation.SuppressLint"));
    private static final Supplier<Name> VALUE = VisitorState.memoize(state -> state.getName("value"));
    private final ImmutableSet<String> suppressWarningsStrings;
    private final ImmutableSet<Name> customSuppressions;
    private final boolean inGeneratedCode;

    private SuppressionInfo(Set<String> suppressWarningsStrings, Set<Name> customSuppressions, boolean inGeneratedCode) {
        this.suppressWarningsStrings = ImmutableSet.copyOf(suppressWarningsStrings);
        this.customSuppressions = ImmutableSet.copyOf(customSuppressions);
        this.inGeneratedCode = inGeneratedCode;
    }

    private static boolean isGenerated(Symbol sym, VisitorState state) {
        return !ASTHelpers.getGeneratedBy(sym, state).isEmpty();
    }

    public SuppressedState suppressedState(Suppressible suppressible, boolean suppressedInGeneratedCode, VisitorState state) {
        if (this.inGeneratedCode && suppressedInGeneratedCode) {
            return SuppressedState.SUPPRESSED;
        }
        if (suppressible.supportsSuppressWarnings() && !Collections.disjoint(suppressible.allNames(), this.suppressWarningsStrings)) {
            return SuppressedState.SUPPRESSED;
        }
        if (suppressible.suppressedByAnyOf(this.customSuppressions, state)) {
            return SuppressedState.SUPPRESSED;
        }
        return SuppressedState.UNSUPPRESSED;
    }

    public SuppressionInfo forCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final AtomicBoolean generated = new AtomicBoolean(false);
        new SimpleTreeVisitor<Void, Void>(){

            @Override
            public Void visitClass(ClassTree node, Void unused) {
                Symbol.ClassSymbol symbol = ASTHelpers.getSymbol(node);
                generated.compareAndSet(false, symbol != null && SuppressionInfo.isGenerated(symbol, state));
                return null;
            }
        }.visit(tree.getTypeDecls(), null);
        return new SuppressionInfo(this.suppressWarningsStrings, this.customSuppressions, generated.get());
    }

    public SuppressionInfo withExtendedSuppressions(Symbol sym, VisitorState state, Set<? extends Name> customSuppressionAnnosToLookFor) {
        Set<Name> newCustomSuppressions;
        boolean newInGeneratedCode = this.inGeneratedCode || SuppressionInfo.isGenerated(sym, state);
        boolean anyModification = newInGeneratedCode != this.inGeneratedCode;
        HashSet<? extends Name> lookingFor = new HashSet<Name>(customSuppressionAnnosToLookFor);
        lookingFor.removeAll(this.customSuppressions);
        Set<Name> newlyPresent = ASTHelpers.annotationsAmong(sym, lookingFor, state);
        if (!newlyPresent.isEmpty()) {
            anyModification = true;
            newCustomSuppressions = newlyPresent;
            newCustomSuppressions.addAll(this.customSuppressions);
        } else {
            newCustomSuppressions = this.customSuppressions;
        }
        Name suppressLint = ANDROID_SUPPRESS_LINT.get(state);
        Name valueName = VALUE.get(state);
        AbstractCollection newSuppressions = null;
        for (Attribute.Compound attr : sym.getAnnotationMirrors()) {
            if (attr.type.tsym != state.getSymtab().suppressWarningsType.tsym && !attr.type.tsym.getQualifiedName().equals(suppressLint)) continue;
            for (Pair<Symbol.MethodSymbol, Attribute> value : attr.values) {
                if (!((Symbol.MethodSymbol)value.fst).name.equals(valueName)) continue;
                if (value.snd instanceof Attribute.Array) {
                    for (Attribute suppress : ((Attribute.Array)value.snd).values) {
                        String suppressedWarning = (String)suppress.getValue();
                        if (this.suppressWarningsStrings.contains(suppressedWarning)) continue;
                        anyModification = true;
                        if (newSuppressions == null) {
                            newSuppressions = new HashSet<String>(this.suppressWarningsStrings);
                        }
                        newSuppressions.add(suppressedWarning);
                    }
                    continue;
                }
                throw new RuntimeException("Expected SuppressWarnings/SuppressLint annotation to take array type");
            }
        }
        if (!anyModification) {
            return this;
        }
        if (newSuppressions == null) {
            newSuppressions = this.suppressWarningsStrings;
        }
        return new SuppressionInfo((Set<String>)((Object)newSuppressions), newCustomSuppressions, newInGeneratedCode);
    }

    public static enum SuppressedState {
        UNSUPPRESSED,
        SUPPRESSED;

    }
}

