/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.apply.ImportOrganizer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class IdeaImportOrganizer
implements ImportOrganizer {
    private static final String JAVA_PREFIX = "java.";
    private static final String JAVAX_PREFIX = "javax.";

    @Override
    public ImportOrganizer.OrganizedImports organizeImports(List<ImportOrganizer.Import> imports) {
        Map partitioned = imports.stream().collect(Collectors.groupingBy(IdeaImportOrganizer::getPackageType, TreeMap::new, ImmutableSortedSet.toImmutableSortedSet(IdeaImportOrganizer::compareImport)));
        return new ImportOrganizer.OrganizedImports().addGroups(partitioned, ImmutableList.of(PackageType.NON_STATIC, PackageType.JAVAX_JAVA, PackageType.STATIC));
    }

    private static int compareImport(ImportOrganizer.Import a, ImportOrganizer.Import b) {
        if (a.isStatic() || b.isStatic()) {
            return a.getType().compareTo(b.getType());
        }
        if (a.getType().startsWith(JAVA_PREFIX) && b.getType().startsWith(JAVAX_PREFIX)) {
            return 1;
        }
        if (a.getType().startsWith(JAVAX_PREFIX) && b.getType().startsWith(JAVA_PREFIX)) {
            return -1;
        }
        return a.getType().compareTo(b.getType());
    }

    private static PackageType getPackageType(ImportOrganizer.Import anImport) {
        if (anImport.isStatic()) {
            return PackageType.STATIC;
        }
        if (anImport.getType().startsWith(JAVA_PREFIX)) {
            return PackageType.JAVAX_JAVA;
        }
        if (anImport.getType().startsWith(JAVAX_PREFIX)) {
            return PackageType.JAVAX_JAVA;
        }
        return PackageType.NON_STATIC;
    }

    private static enum PackageType {
        JAVAX_JAVA,
        NON_STATIC,
        STATIC;

    }
}

