/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.UnusedReturnValueMatcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

public abstract class AbstractMustBeClosedChecker
extends BugChecker {
    private static final String MUST_BE_CLOSED_ANNOTATION_NAME = MustBeClosed.class.getCanonicalName();
    protected static final Matcher<Tree> HAS_MUST_BE_CLOSED_ANNOTATION = Matchers.symbolHasAnnotation(MUST_BE_CLOSED_ANNOTATION_NAME);
    private static final Matcher<ExpressionTree> CLOSE_METHOD = Matchers.instanceMethod().onDescendantOf("java.lang.AutoCloseable").named("close");
    private static final Matcher<Tree> MOCKITO_MATCHER = Matchers.toType(MethodInvocationTree.class, MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("when"));

    protected Description scanEntireMethodFor(final Matcher<? super MethodInvocationTree> m, MethodTree tree, final VisitorState state) {
        final FixAggregator aggregator = this.findingPerMethod();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree methodTree, Void aVoid) {
                return null;
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, Void aVoid) {
                VisitorState localState = state.withPath(this.getCurrentPath());
                if (m.matches(methodInvocationTree, localState)) {
                    Description description = AbstractMustBeClosedChecker.this.matchNewClassOrMethodInvocation(methodInvocationTree, localState, aggregator);
                    Verify.verify(description.fixes.isEmpty());
                }
                return (Void)super.visitMethodInvocation(methodInvocationTree, aVoid);
            }
        }.scan(tree.getBody(), null);
        return aggregator.flush().map(fix -> this.describeMatch(tree, (Fix)fix)).orElse(Description.NO_MATCH);
    }

    protected Description matchNewClassOrMethodInvocation(ExpressionTree tree, VisitorState state, FixAggregator aggregator) {
        if (AbstractMustBeClosedChecker.isInStaticInitializer(state)) {
            return Description.NO_MATCH;
        }
        Description description = this.checkClosed(tree, state, aggregator);
        if (description == Description.NO_MATCH) {
            return Description.NO_MATCH;
        }
        if (UnusedReturnValueMatcher.expectedExceptionTest(state) || UnusedReturnValueMatcher.mockitoInvocation(tree, state) || MOCKITO_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        return description;
    }

    private Description checkClosed(ExpressionTree tree, VisitorState state, FixAggregator aggregator) {
        MethodTree callerMethodTree = AbstractMustBeClosedChecker.enclosingMethod(state);
        TreePath path = state.getPath();
        block8: while (true) {
            TreePath prev = path;
            path = path.getParentPath();
            switch (path.getLeaf().getKind()) {
                case RETURN: {
                    if (callerMethodTree != null) {
                        if (HAS_MUST_BE_CLOSED_ANNOTATION.matches(callerMethodTree, state)) {
                            return Description.NO_MATCH;
                        }
                        return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith(callerMethodTree, "@MustBeClosed\n").addImport(MustBeClosed.class.getCanonicalName()).build());
                    }
                    return this.handleTailPositionInLambda(tree, state);
                }
                case LAMBDA_EXPRESSION: {
                    return this.handleTailPositionInLambda(tree, state);
                }
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)path.getLeaf();
                    if (!conditionalExpressionTree.getTrueExpression().equals(prev.getLeaf()) && !conditionalExpressionTree.getFalseExpression().equals(prev.getLeaf())) break block8;
                    continue block8;
                }
                case MEMBER_SELECT: {
                    MemberSelectTree memberSelectTree = (MemberSelectTree)path.getLeaf();
                    if (!memberSelectTree.getExpression().equals(prev.getLeaf())) break block8;
                    Type type = ASTHelpers.getType(memberSelectTree);
                    Symbol sym = ASTHelpers.getSymbol(memberSelectTree);
                    Type streamType = state.getTypeFromString(Stream.class.getName());
                    if (!ASTHelpers.isSubtype((Type)sym.enclClass().asType(), streamType, state) || !ASTHelpers.isSameType(type.getReturnType(), streamType, state)) break block8;
                    path = path.getParentPath();
                    continue block8;
                }
                case VARIABLE: {
                    Symbol.VarSymbol var;
                    Symbol sym = ASTHelpers.getSymbol(path.getLeaf());
                    if (!(sym instanceof Symbol.VarSymbol) || (var = (Symbol.VarSymbol)sym).getKind() != ElementKind.RESOURCE_VARIABLE && !AbstractMustBeClosedChecker.isClosedInFinallyClause(var, path, state) && !AbstractMustBeClosedChecker.variableInitializationCountsAsClosing(var)) break block8;
                    return Description.NO_MATCH;
                }
                case ASSIGNMENT: {
                    return this.emptyFix(tree);
                }
            }
            break;
        }
        Description.Builder description = this.buildDescription(tree);
        this.addFix(description, tree, state, aggregator);
        return description.build();
    }

    private Description handleTailPositionInLambda(ExpressionTree tree, VisitorState state) {
        LambdaExpressionTree lambda = ASTHelpers.findEnclosingNode(state.getPath(), LambdaExpressionTree.class);
        if (lambda == null) {
            return this.emptyFix(tree);
        }
        if (ASTHelpers.hasAnnotation(state.getTypes().findDescriptorSymbol(ASTHelpers.getType((Tree)lambda).tsym), MUST_BE_CLOSED_ANNOTATION_NAME, state)) {
            return Description.NO_MATCH;
        }
        return this.emptyFix(tree);
    }

    private Description emptyFix(Tree tree) {
        return this.describeMatch(tree);
    }

    private static boolean variableInitializationCountsAsClosing(Symbol.VarSymbol var) {
        return (var.isStatic() || var.owner.isEnum()) && var.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isInStaticInitializer(VisitorState state) {
        return Streams.stream(state.getPath()).anyMatch(tree -> tree instanceof VariableTree && AbstractMustBeClosedChecker.variableInitializationCountsAsClosing((Symbol.VarSymbol)ASTHelpers.getSymbol(tree)) || tree instanceof AssignmentTree && ASTHelpers.getSymbol(((AssignmentTree)tree).getVariable()) instanceof Symbol.VarSymbol && AbstractMustBeClosedChecker.variableInitializationCountsAsClosing((Symbol.VarSymbol)ASTHelpers.getSymbol(((AssignmentTree)tree).getVariable())));
    }

    @Nullable
    private static MethodTree enclosingMethod(VisitorState state) {
        for (Tree node : state.getPath().getParentPath()) {
            switch (node.getKind()) {
                case LAMBDA_EXPRESSION: 
                case NEW_CLASS: {
                    return null;
                }
                case METHOD: {
                    return (MethodTree)node;
                }
            }
        }
        return null;
    }

    private static boolean isClosedInFinallyClause(final Symbol.VarSymbol var, TreePath path, final VisitorState state) {
        if (!ASTHelpers.isConsideredFinal(var)) {
            return false;
        }
        Tree parent = path.getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.BLOCK) {
            return false;
        }
        BlockTree block = (BlockTree)parent;
        int idx = block.getStatements().indexOf(path.getLeaf());
        if (idx == -1 || idx == block.getStatements().size() - 1) {
            return false;
        }
        StatementTree next = block.getStatements().get(idx + 1);
        if (!(next instanceof TryTree)) {
            return false;
        }
        TryTree tryTree = (TryTree)next;
        if (tryTree.getFinallyBlock() == null) {
            return false;
        }
        final boolean[] closed = new boolean[]{false};
        tryTree.getFinallyBlock().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (CLOSE_METHOD.matches(tree, state) && Objects.equals(ASTHelpers.getSymbol(ASTHelpers.getReceiver(tree)), var)) {
                    closed[0] = true;
                }
                return null;
            }
        }, null);
        return closed[0];
    }

    private Optional<TryBlock> chooseFixType(ExpressionTree tree, VisitorState state) {
        TreePath path = state.getPath();
        Tree parent = path.getParentPath().getLeaf();
        if (parent instanceof VariableTree) {
            return this.wrapTryFinallyAroundVariableScope((VariableTree)parent, state);
        }
        StatementTree stmt = (StatementTree)state.findEnclosing(StatementTree.class);
        if (stmt == null) {
            return Optional.empty();
        }
        if (!(stmt instanceof VariableTree)) {
            return this.introduceSingleStatementTry(tree, stmt, state);
        }
        Symbol.VarSymbol varSym = ASTHelpers.getSymbol((VariableTree)stmt);
        if (varSym.getKind() == ElementKind.RESOURCE_VARIABLE) {
            return this.extractToResourceInCurrentTry(tree, stmt, state);
        }
        return this.splitVariableDeclarationAroundTry(tree, (VariableTree)stmt, state);
    }

    protected void addFix(Description.Builder description, ExpressionTree tree, VisitorState state, FixAggregator aggregator) {
        this.chooseFixType(tree, state).flatMap(aggregator::report).ifPresent(description::addFix);
    }

    private Optional<TryBlock> introduceSingleStatementTry(ExpressionTree tree, StatementTree stmt, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        if (type == null) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String name = this.suggestName(tree);
        if (state.getPath().getParentPath().getLeaf() instanceof ExpressionStatementTree) {
            fix.delete(stmt);
        } else {
            fix.replace(tree, name);
        }
        return Optional.of(new TryBlock(stmt, fix.prefixWith(stmt, String.format("try (%s %s = %s) {", SuggestedFixes.qualifyType(state, fix, type), name, state.getSourceForNode(tree)))));
    }

    private Optional<TryBlock> extractToResourceInCurrentTry(ExpressionTree tree, StatementTree declaringStatement, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        if (type == null) {
            return Optional.empty();
        }
        String name = this.suggestName(tree);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return Optional.of(new TryBlock(fix.prefixWith(declaringStatement, String.format("%s %s = %s;", SuggestedFixes.qualifyType(state, fix, type), name, state.getSourceForNode(tree))).replace(tree, name)));
    }

    private Optional<TryBlock> splitVariableDeclarationAroundTry(ExpressionTree tree, VariableTree var, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        if (type == null) {
            return Optional.empty();
        }
        int initPos = ASTHelpers.getStartPosition(var.getInitializer());
        int afterTypePos = state.getEndPosition(var.getType());
        String name = this.suggestName(tree);
        SuggestedFix.Builder fix = SuggestedFix.builder();
        return Optional.of(new TryBlock(var, fix.replace(afterTypePos, initPos, String.format(" %s;\ntry (%s %s = %s) {\n%s =", var.getName(), SuggestedFixes.qualifyType(state, fix, type), name, state.getSourceForNode(tree), var.getName())).replace(tree, name)));
    }

    private Optional<TryBlock> wrapTryFinallyAroundVariableScope(VariableTree decl, VisitorState state) {
        BlockTree enclosingBlock = (BlockTree)state.findEnclosing(BlockTree.class);
        if (enclosingBlock == null) {
            return Optional.empty();
        }
        return Optional.of(new TryBlock(enclosingBlock, SuggestedFix.builder().prefixWith(decl, String.format("try (%s %s = %s) {", state.getSourceForNode(decl.getType()), decl.getName().toString(), state.getSourceForNode(decl.getInitializer()))).delete(decl)));
    }

    private String suggestName(ExpressionTree tree) {
        String symbolName;
        switch (tree.getKind()) {
            case NEW_CLASS: {
                symbolName = ASTHelpers.getSymbol(((NewClassTree)tree).getIdentifier()).getSimpleName().toString();
                break;
            }
            case METHOD_INVOCATION: {
                symbolName = ((Name)ASTHelpers.getReturnType(tree).asElement().getSimpleName()).toString();
                break;
            }
            default: {
                throw new AssertionError((Object)tree.getKind());
            }
        }
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, symbolName);
    }

    protected FixAggregator findingPerMethod() {
        return new FindingPerMethod();
    }

    protected FixAggregator findingPerSite() {
        return FindingPerSite.INSTANCE;
    }

    private static final class FindingPerSite
    implements FixAggregator {
        private static final FindingPerSite INSTANCE = new FindingPerSite();

        private FindingPerSite() {
        }

        @Override
        public Optional<SuggestedFix> report(TryBlock t) {
            return Optional.of(t.closeBraceAfter.map(where -> t.otherChanges.postfixWith((Tree)where, "}")).orElse(t.otherChanges).build());
        }

        @Override
        public Optional<SuggestedFix> flush() {
            return Optional.empty();
        }
    }

    private static final class FindingPerMethod
    implements FixAggregator {
        private final ListMultimap<Optional<Tree>, TryBlock> reports = ArrayListMultimap.create();

        private FindingPerMethod() {
        }

        @Override
        public Optional<SuggestedFix> report(TryBlock fix) {
            this.reports.put(fix.closeBraceAfter, fix);
            return Optional.empty();
        }

        @Override
        public Optional<SuggestedFix> flush() {
            if (this.reports.isEmpty()) {
                return Optional.empty();
            }
            SuggestedFix.Builder fix = SuggestedFix.builder();
            for (Map.Entry<Optional<Tree>, Collection<TryBlock>> e : this.reports.asMap().entrySet()) {
                Optional<Tree> block = e.getKey();
                Collection<TryBlock> changes = e.getValue();
                block.ifPresent(b -> fix.postfixWith((Tree)b, Strings.repeat("}", changes.size())));
                for (TryBlock change : changes) {
                    fix.merge(change.otherChanges);
                }
            }
            this.reports.clear();
            return Optional.of(fix.build());
        }
    }

    protected static interface FixAggregator {
        public Optional<SuggestedFix> report(TryBlock var1);

        public Optional<SuggestedFix> flush();
    }

    private static class TryBlock {
        final Optional<Tree> closeBraceAfter;
        final SuggestedFix.Builder otherChanges;

        TryBlock(SuggestedFix.Builder changes) {
            this.closeBraceAfter = Optional.empty();
            this.otherChanges = changes;
        }

        TryBlock(Tree closeBraceAfter, SuggestedFix.Builder otherChanges) {
            this.closeBraceAfter = Optional.of(closeBraceAfter);
            this.otherChanges = otherChanges;
        }
    }
}

