/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.ConstantExpressions;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.UnusedReturnValueMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeKind;

public abstract class AbstractReturnValueIgnored
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private final Supplier<UnusedReturnValueMatcher> unusedReturnValueMatcher = Suppliers.memoize(() -> UnusedReturnValueMatcher.get(this.allowInExceptionThrowers()));
    private final Supplier<Matcher<ExpressionTree>> matcher = Suppliers.memoize(() -> Matchers.allOf(this.unusedReturnValueMatcher.get(), this::isCheckReturnValue));
    private final Supplier<Matcher<MemberReferenceTree>> lostReferenceTreeMatcher = Suppliers.memoize(() -> Matchers.allOf(AbstractReturnValueIgnored::isObjectReturningMethodReferenceExpression, Matchers.not((t, s) -> AbstractReturnValueIgnored.isExemptedInterfaceType(ASTHelpers.getType(t), s)), Matchers.not((t, s) -> Matchers.isThrowingFunctionalInterface(ASTHelpers.getType(t), s)), this.specializedMatcher()));
    private final ConstantExpressions constantExpressions;
    private static final ImmutableSet<String> EXEMPTED_TYPES = ImmutableSet.of("org.mockito.stubbing.Answer", "graphql.schema.DataFetcher", "org.jmock.lib.action.CustomAction", "net.sf.cglib.proxy.MethodInterceptor", "org.aopalliance.intercept.MethodInterceptor", InvocationHandler.class.getName(), new String[0]);

    protected AbstractReturnValueIgnored() {
        this(ErrorProneFlags.empty());
    }

    protected AbstractReturnValueIgnored(ErrorProneFlags flags) {
        this.constantExpressions = ConstantExpressions.fromFlags(flags);
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Description description;
        Description description2 = description = this.matcher.get().matches(methodInvocationTree, state) ? this.describeReturnValueIgnored(methodInvocationTree, state) : Description.NO_MATCH;
        if (!description.equals(Description.NO_MATCH)) {
            return description;
        }
        return this.checkLostType(methodInvocationTree, state);
    }

    @Override
    public Description matchNewClass(NewClassTree newClassTree, VisitorState state) {
        return this.matcher.get().matches(newClassTree, state) ? this.describeReturnValueIgnored(newClassTree, state) : Description.NO_MATCH;
    }

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        Description description;
        Description description2 = description = this.matcher.get().matches(tree, state) ? this.describeReturnValueIgnored(tree, state) : Description.NO_MATCH;
        if (!this.lostType(state).isPresent() || !description.equals(Description.NO_MATCH)) {
            return description;
        }
        if (this.lostReferenceTreeMatcher.get().matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return description;
    }

    public boolean isCovered(ExpressionTree tree, VisitorState state) {
        return this.isCheckReturnValue(tree, state);
    }

    public final boolean isCheckReturnValue(ExpressionTree tree, VisitorState state) {
        return this.specializedMatcher().matches(tree, state);
    }

    public ImmutableMap<String, ?> getMatchMetadata(ExpressionTree tree, VisitorState state) {
        return ImmutableMap.of();
    }

    protected abstract Matcher<? super ExpressionTree> specializedMatcher();

    protected Optional<Type> lostType(VisitorState state) {
        return Optional.empty();
    }

    protected String lostTypeMessage(String returnedType, String declaredReturnType) {
        return String.format("Returning %s from method that returns %s.", returnedType, declaredReturnType);
    }

    protected boolean allowInExceptionThrowers() {
        return true;
    }

    protected Description describeReturnValueIgnored(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return this.buildDescription(methodInvocationTree).addFix(this.makeFix(methodInvocationTree, state)).setMessage(this.getMessage(ASTHelpers.getSymbol(methodInvocationTree).getSimpleName())).build();
    }

    final Fix makeFix(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ExpressionTree identifierExpr = ASTHelpers.getRootAssignable(methodInvocationTree);
        Type identifierType = null;
        if (identifierExpr != null) {
            if (identifierExpr instanceof JCTree.JCIdent) {
                identifierType = ((JCTree.JCIdent)identifierExpr).sym.type;
            } else if (identifierExpr instanceof JCTree.JCFieldAccess) {
                identifierType = ((JCTree.JCFieldAccess)identifierExpr).sym.type;
            } else {
                throw new IllegalStateException("Expected a JCIdent or a JCFieldAccess");
            }
        }
        Type returnType = ASTHelpers.getReturnType(((JCTree.JCMethodInvocation)methodInvocationTree).getMethodSelect());
        SuggestedFix fix = SuggestedFix.emptyFix();
        Symbol symbol = ASTHelpers.getSymbol(identifierExpr);
        if (identifierExpr != null && symbol != null && !symbol.name.contentEquals("this") && returnType != null && state.getTypes().isAssignable(returnType, identifierType)) {
            fix = SuggestedFix.prefixWith(methodInvocationTree, state.getSourceForNode(identifierExpr) + " = ");
        } else {
            Tree parent = state.getPath().getParentPath().getLeaf();
            if (parent instanceof ExpressionStatementTree && this.constantExpressions.constantExpression(methodInvocationTree, state).isPresent()) {
                fix = SuggestedFix.delete(parent);
            }
        }
        return fix;
    }

    protected Description describeReturnValueIgnored(MemberReferenceTree memberReferenceTree, VisitorState state) {
        return this.buildDescription(memberReferenceTree).setMessage(this.getMessage(state.getName(AbstractReturnValueIgnored.descriptiveNameForMemberReference(memberReferenceTree, state)))).build();
    }

    protected Description describeReturnValueIgnored(NewClassTree newClassTree, VisitorState state) {
        return this.buildDescription(newClassTree).setMessage(String.format("Ignored return value of '%s'", state.getSourceForNode(newClassTree.getIdentifier()))).build();
    }

    private static String descriptiveNameForMemberReference(MemberReferenceTree memberReferenceTree, VisitorState state) {
        if (memberReferenceTree.getMode() == MemberReferenceTree.ReferenceMode.NEW) {
            return state.getSourceForNode(memberReferenceTree.getQualifierExpression());
        }
        return memberReferenceTree.getName().toString();
    }

    protected String getMessage(Name name) {
        return this.message();
    }

    private Description checkLostType(MethodInvocationTree tree, VisitorState state) {
        Optional<Type> optionalType = this.lostType(state);
        if (!optionalType.isPresent()) {
            return Description.NO_MATCH;
        }
        Type lostType = optionalType.get();
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        Type returnType = ASTHelpers.getResultType(tree);
        Type returnedFutureType = state.getTypes().asSuper(returnType, lostType.tsym);
        if (returnedFutureType != null && !returnedFutureType.hasTag(TypeTag.ERROR) && !returnedFutureType.isRaw()) {
            if (ASTHelpers.isSubtype(ASTHelpers.getUpperBound(returnedFutureType.getTypeArguments().get(0), state.getTypes()), lostType, state)) {
                return this.buildDescription(tree).setMessage(String.format("Method returns a nested type, %s", returnType)).build();
            }
            Type methodReturnType = sym.getReturnType();
            List typeParameters = sym.getTypeParameters();
            HashSet<Symbol.TypeVariableSymbol> returnTypeChoosing = new HashSet<Symbol.TypeVariableSymbol>();
            for (Symbol.TypeVariableSymbol tvs : typeParameters) {
                ArrayDeque<Symbol.TypeVariableSymbol> queue = new ArrayDeque<Symbol.TypeVariableSymbol>();
                queue.add(tvs);
                while (!queue.isEmpty()) {
                    Symbol.TypeVariableSymbol currentTypeParam = (Symbol.TypeVariableSymbol)queue.remove();
                    for (Type typeParam : methodReturnType.getTypeArguments()) {
                        if (typeParam.tsym != currentTypeParam) continue;
                        returnTypeChoosing.add(tvs);
                    }
                    for (Type toAdd : currentTypeParam.getBounds()) {
                        if (!(toAdd.tsym instanceof Symbol.TypeVariableSymbol)) continue;
                        queue.add((Symbol.TypeVariableSymbol)toAdd.tsym);
                    }
                }
            }
            if (!returnTypeChoosing.isEmpty()) {
                ListMultimap<Symbol.TypeVariableSymbol, TypeInfo> resolved = AbstractReturnValueIgnored.getResolvedGenerics(tree);
                for (Symbol.TypeVariableSymbol returnTypeChoosingSymbol : returnTypeChoosing) {
                    Collection types = resolved.get((Object)returnTypeChoosingSymbol);
                    for (TypeInfo type : types) {
                        if (!ASTHelpers.isSubtype(type.resolvedVariableType, lostType, state)) continue;
                        return this.buildDescription(type.tree).setMessage(String.format("Invocation produces a nested type - Type variable %s, as part of return type %s resolved to %s.", returnTypeChoosingSymbol, methodReturnType, type.resolvedVariableType)).build();
                    }
                }
            }
        }
        Matcher[] matcherArray = new Matcher[3];
        Matcher[] matcherArray2 = new Matcher[2];
        matcherArray2[0] = Matchers.parentNode(AbstractReturnValueIgnored::isObjectReturningLambdaExpression);
        matcherArray2[1] = Matchers.not(this.unusedReturnValueMatcher.get()::isAllowed);
        matcherArray[0] = Matchers.allOf(matcherArray2);
        matcherArray[1] = this.specializedMatcher();
        matcherArray[2] = Matchers.not((t, s) -> ASTHelpers.isVoidType(ASTHelpers.getType(t), s));
        if (Matchers.allOf(matcherArray).matches(tree, state)) {
            return this.describeReturnValueIgnored(tree, state);
        }
        return Description.NO_MATCH;
    }

    private static ListMultimap<Symbol.TypeVariableSymbol, TypeInfo> getResolvedGenerics(MethodInvocationTree tree) {
        Type type = ASTHelpers.getType(tree.getMethodSelect());
        ImmutableListMultimap<Symbol.TypeVariableSymbol, Type> subst = ASTHelpers.getTypeSubstitution(type, ASTHelpers.getSymbol(tree));
        return subst.entries().stream().map(e -> new TypeInfo((Symbol.TypeVariableSymbol)e.getKey(), (Type)e.getValue(), tree)).collect(Multimaps.toMultimap(k -> k.sym, k -> k, MultimapBuilder.linkedHashKeys().arrayListValues()::build));
    }

    private static boolean isObjectReturningMethodReferenceExpression(MemberReferenceTree tree, VisitorState state) {
        return AbstractReturnValueIgnored.functionalInterfaceReturnsObject(ASTHelpers.getType(tree), state);
    }

    private static boolean isObjectReturningLambdaExpression(Tree tree, VisitorState state) {
        if (!(tree instanceof LambdaExpressionTree)) {
            return false;
        }
        Type type = ASTHelpers.getType(tree);
        return AbstractReturnValueIgnored.functionalInterfaceReturnsObject(type, state) && !AbstractReturnValueIgnored.isExemptedInterfaceType(type, state);
    }

    private static boolean functionalInterfaceReturnsObject(Type interfaceType, VisitorState state) {
        Type objectType = state.getSymtab().objectType;
        return ASTHelpers.isSubtype(objectType, ASTHelpers.getUpperBound(state.getTypes().findDescriptorType(interfaceType).getReturnType(), state.getTypes()), state);
    }

    private static boolean isExemptedInterfaceType(Type type, VisitorState state) {
        return EXEMPTED_TYPES.stream().map(state::getTypeFromString).anyMatch(t -> ASTHelpers.isSubtype(type, t, state));
    }

    private static boolean isExemptedInterfaceMethod(Symbol.MethodSymbol symbol, VisitorState state) {
        return AbstractReturnValueIgnored.isExemptedInterfaceType(ASTHelpers.enclosingClass((Symbol)symbol).type, state);
    }

    @Override
    public Description matchReturn(ReturnTree tree, VisitorState state) {
        Optional<Type> optionalType = this.lostType(state);
        if (!optionalType.isPresent()) {
            return Description.NO_MATCH;
        }
        Type objectType = state.getSymtab().objectType;
        Type lostType = optionalType.get();
        Type resultType = ASTHelpers.getResultType(tree.getExpression());
        if (resultType == null) {
            return Description.NO_MATCH;
        }
        if (resultType.getKind() == TypeKind.NULL || resultType.getKind() == TypeKind.NONE) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSubtype(resultType, lostType, state)) {
            for (Tree enclosing : state.getPath()) {
                if (enclosing instanceof MethodTree) {
                    MethodTree methodTree = (MethodTree)enclosing;
                    Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(methodTree);
                    if (!ASTHelpers.isSubtype(objectType, symbol.getReturnType(), state) || AbstractReturnValueIgnored.isExemptedInterfaceMethod(symbol, state)) break;
                    return this.buildDescription(tree).setMessage(this.lostTypeMessage(resultType.toString(), symbol.getReturnType().toString())).build();
                }
                if (!(enclosing instanceof LambdaExpressionTree)) continue;
                LambdaExpressionTree lambdaTree = (LambdaExpressionTree)enclosing;
                if (!AbstractReturnValueIgnored.isObjectReturningLambdaExpression(lambdaTree, state)) break;
                return this.buildDescription(tree).setMessage(this.lostTypeMessage(resultType.toString(), "Object")).build();
            }
        }
        return Description.NO_MATCH;
    }

    private static final class TypeInfo {
        private final Symbol.TypeVariableSymbol sym;
        private final Type resolvedVariableType;
        private final Tree tree;

        private TypeInfo(Symbol.TypeVariableSymbol sym, Type resolvedVariableType, Tree tree) {
            this.sym = sym;
            this.resolvedVariableType = resolvedVariableType;
            this.tree = tree;
        }
    }
}

