/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;

@BugPattern(summary="Annotations should be positioned after Javadocs, but before modifiers.", severity=BugPattern.SeverityLevel.WARNING, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s4.8.5-annotations")
public final class AnnotationPosition
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableMap<String, Tokens.TokenKind> TOKEN_KIND_BY_NAME = Arrays.stream(Tokens.TokenKind.values()).collect(ImmutableMap.toImmutableMap(tk -> tk.name(), tk -> tk));
    private static final ImmutableSet<Tokens.TokenKind> MODIFIERS = Streams.concat(Arrays.stream(Modifier.values()).map(m -> TOKEN_KIND_BY_NAME.get(m.name())).filter(Objects::nonNull), Stream.of(Tokens.TokenKind.LT, Tokens.TokenKind.GT, Tokens.TokenKind.GTGT)).collect(ImmutableSet.toImmutableSet());

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        return this.handle(tree, tree.getSimpleName(), tree.getModifiers(), state);
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        return this.handle(tree, tree.getName(), tree.getModifiers(), state);
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        return this.handle(tree, tree.getName(), tree.getModifiers(), state);
    }

    private Description handle(Tree tree, Name name, ModifiersTree modifiers, VisitorState state) {
        int lastModifierPos;
        ImmutableList modifierTokens;
        int firstModifierPos;
        java.util.List<? extends AnnotationTree> annotations = modifiers.getAnnotations();
        if (annotations.isEmpty()) {
            return Description.NO_MATCH;
        }
        int treePos = ASTHelpers.getStartPosition(tree);
        java.util.List<ErrorProneToken> tokens = AnnotationPosition.annotationTokens(tree, state, treePos);
        Tokens.Comment danglingJavadoc = AnnotationPosition.findOrphanedJavadoc(name, tokens);
        Description description = this.checkAnnotations(tree, annotations, danglingJavadoc, firstModifierPos = (modifierTokens = tokens.stream().filter(t -> MODIFIERS.contains(t.kind())).collect(ImmutableList.toImmutableList())).stream().findFirst().map(x -> x.pos()).orElse(Integer.MAX_VALUE).intValue(), lastModifierPos = Streams.findLast(modifierTokens.stream()).map(x -> x.endPos()).orElse(0).intValue(), state);
        if (!description.equals(Description.NO_MATCH)) {
            return description;
        }
        if (danglingJavadoc == null) {
            return Description.NO_MATCH;
        }
        if (JavacTrees.instance(state.context).getDocCommentTree(state.getPath()) != null) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String javadoc = AnnotationPosition.removeJavadoc(state, danglingJavadoc, builder);
        String message = "Javadocs should appear before any modifiers or annotations.";
        return this.buildDescription(tree).setMessage(message).addFix(builder.prefixWith(tree, javadoc).build()).build();
    }

    private static java.util.List<ErrorProneToken> annotationTokens(Tree tree, VisitorState state, int annotationEnd) {
        int endPos;
        if (tree instanceof JCTree.JCMethodDecl) {
            JCTree.JCMethodDecl methodTree = (JCTree.JCMethodDecl)tree;
            endPos = methodTree.getReturnType() != null ? ASTHelpers.getStartPosition(methodTree.getReturnType()) : (!((List)methodTree.getParameters()).isEmpty() ? ASTHelpers.getStartPosition((Tree)((List)methodTree.getParameters()).get(0)) : (methodTree.getBody() != null && !((List)methodTree.getBody().getStatements()).isEmpty() ? ASTHelpers.getStartPosition((Tree)((List)methodTree.getBody().getStatements()).get(0)) : state.getEndPosition(methodTree)));
        } else if (tree instanceof JCTree.JCVariableDecl) {
            endPos = state.getEndPosition(((JCTree.JCVariableDecl)tree).getModifiers());
        } else if (tree instanceof JCTree.JCClassDecl) {
            JCTree.JCClassDecl classTree = (JCTree.JCClassDecl)tree;
            endPos = ((List)classTree.getMembers()).isEmpty() ? state.getEndPosition(classTree) : ((JCTree)((List)classTree.getMembers()).get(0)).getStartPosition();
        } else {
            throw new AssertionError();
        }
        return state.getOffsetTokens(annotationEnd, endPos);
    }

    private Description checkAnnotations(Tree tree, java.util.List<? extends AnnotationTree> annotations, Tokens.Comment danglingJavadoc, int firstModifierPos, int lastModifierPos, VisitorState state) {
        String isAre;
        String flattened;
        ImmutableList<String> names;
        String javadoc;
        boolean annotationsInCorrectPlace;
        Symbol symbol = ASTHelpers.getSymbol(tree);
        ImmutableList<AnnotationTree> shouldBeBefore = annotations.stream().filter(a -> {
            Position position = AnnotationPosition.annotationPosition(tree, ASTHelpers.getAnnotationType(a, symbol, state));
            return position == Position.BEFORE || position == Position.EITHER && ASTHelpers.getStartPosition(a) < firstModifierPos;
        }).collect(ImmutableList.toImmutableList());
        ImmutableList<AnnotationTree> shouldBeAfter = annotations.stream().filter(a -> {
            Position position = AnnotationPosition.annotationPosition(tree, ASTHelpers.getAnnotationType(a, symbol, state));
            return position == Position.AFTER || position == Position.EITHER && ASTHelpers.getStartPosition(a) > firstModifierPos;
        }).collect(ImmutableList.toImmutableList());
        boolean bl = annotationsInCorrectPlace = shouldBeBefore.stream().allMatch(a -> ASTHelpers.getStartPosition(a) < firstModifierPos) && shouldBeAfter.stream().allMatch(a -> ASTHelpers.getStartPosition(a) > lastModifierPos);
        if (annotationsInCorrectPlace && AnnotationPosition.isOrderingIsCorrect(shouldBeBefore, shouldBeAfter)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        for (AnnotationTree annotation : Iterables.concat(shouldBeBefore, shouldBeAfter)) {
            fix.delete(annotation);
        }
        String string = javadoc = danglingJavadoc == null ? "" : AnnotationPosition.removeJavadoc(state, danglingJavadoc, fix);
        if (lastModifierPos == 0) {
            fix.replace(ASTHelpers.getStartPosition(tree), ASTHelpers.getStartPosition(tree), String.format("%s%s ", javadoc, AnnotationPosition.joinSource(state, Iterables.concat(shouldBeBefore, shouldBeAfter))));
        } else {
            fix.replace(firstModifierPos, firstModifierPos, String.format("%s%s ", javadoc, AnnotationPosition.joinSource(state, shouldBeBefore))).replace(lastModifierPos, lastModifierPos, String.format(" %s ", AnnotationPosition.joinSource(state, shouldBeAfter)));
        }
        Stream.Builder<String> messages = Stream.builder();
        if (!shouldBeBefore.isEmpty()) {
            names = AnnotationPosition.annotationNames(shouldBeBefore);
            flattened = String.join((CharSequence)", ", names);
            isAre = names.size() > 1 ? "are not TYPE_USE annotations" : "is not a TYPE_USE annotation";
            messages.add(String.format("%s %s, so should appear before any modifiers and after Javadocs.", flattened, isAre));
        }
        if (!shouldBeAfter.isEmpty()) {
            names = AnnotationPosition.annotationNames(shouldBeAfter);
            flattened = String.join((CharSequence)", ", names);
            isAre = names.size() > 1 ? "are TYPE_USE annotations" : "is a TYPE_USE annotation";
            messages.add(String.format("%s %s, so should appear after modifiers and directly before the type.", flattened, isAre));
        }
        return this.buildDescription(tree).setMessage(messages.build().collect(Collectors.joining(" "))).addFix(fix.build()).build();
    }

    private static boolean isOrderingIsCorrect(java.util.List<AnnotationTree> shouldBeBefore, java.util.List<AnnotationTree> shouldBeAfter) {
        int smallestTypeAnnotationPosition;
        if (shouldBeBefore.isEmpty() || shouldBeAfter.isEmpty()) {
            return true;
        }
        int largestNonTypeAnnotationPosition = shouldBeBefore.stream().map(ASTHelpers::getStartPosition).max(Comparator.naturalOrder()).get();
        return largestNonTypeAnnotationPosition < (smallestTypeAnnotationPosition = shouldBeAfter.stream().map(ASTHelpers::getStartPosition).min(Comparator.naturalOrder()).get().intValue());
    }

    private static Position annotationPosition(Tree tree, TypeAnnotations.AnnotationType annotationType) {
        if (tree instanceof ClassTree || annotationType == null) {
            return Position.BEFORE;
        }
        switch (annotationType) {
            case DECLARATION: {
                return Position.BEFORE;
            }
            case TYPE: {
                return Position.AFTER;
            }
            case NONE: 
            case BOTH: {
                return Position.EITHER;
            }
        }
        throw new AssertionError();
    }

    private static ImmutableList<String> annotationNames(java.util.List<AnnotationTree> annotations) {
        return annotations.stream().map(ASTHelpers::getSymbol).filter(Objects::nonNull).map(Symbol::getSimpleName).map(a -> "@" + a).collect(ImmutableList.toImmutableList());
    }

    private static String joinSource(VisitorState state, Iterable<AnnotationTree> moveBefore) {
        return Streams.stream(moveBefore).map(state::getSourceForNode).collect(Collectors.joining(" "));
    }

    private static String removeJavadoc(VisitorState state, Tokens.Comment danglingJavadoc, SuggestedFix.Builder builder) {
        int javadocStart = danglingJavadoc.getSourcePos(0);
        int javadocEnd = javadocStart + danglingJavadoc.getText().length();
        if (state.getSourceCode().charAt(javadocEnd) == '\n') {
            ++javadocEnd;
        }
        builder.replace(javadocStart, javadocEnd, "");
        return danglingJavadoc.getText();
    }

    @Nullable
    private static Tokens.Comment findOrphanedJavadoc(Name name, java.util.List<ErrorProneToken> tokens) {
        for (ErrorProneToken token : tokens) {
            for (Tokens.Comment comment : token.comments()) {
                if (!comment.getText().startsWith("/**")) continue;
                return comment;
            }
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(name)) continue;
            return null;
        }
        return null;
    }

    private static enum Position {
        BEFORE,
        AFTER,
        EITHER;

    }
}

