/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(summary="Reference equality used to compare arrays", severity=BugPattern.SeverityLevel.ERROR)
public class ArrayEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> instanceEqualsMatcher = Matchers.allOf(Matchers.instanceMethod().onClass(TypePredicates.isArray()).named("equals"), Matchers.argument(0, Matchers.isArrayType()));
    private static final Matcher<MethodInvocationTree> staticEqualsMatcher = Matchers.allOf(Matchers.staticEqualsInvocation(), Matchers.argument(0, Matchers.isArrayType()), Matchers.argument(1, Matchers.isArrayType()));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        String arg2;
        String arg1;
        if (instanceEqualsMatcher.matches(t, state)) {
            arg1 = state.getSourceForNode(((JCTree.JCFieldAccess)t.getMethodSelect()).getExpression());
            arg2 = state.getSourceForNode(t.getArguments().get(0));
        } else if (staticEqualsMatcher.matches(t, state)) {
            arg1 = state.getSourceForNode(t.getArguments().get(0));
            arg2 = state.getSourceForNode(t.getArguments().get(1));
        } else {
            return Description.NO_MATCH;
        }
        SuggestedFix fix = SuggestedFix.builder().replace(t, "Arrays.equals(" + arg1 + ", " + arg2 + ")").addImport("java.util.Arrays").build();
        return this.describeMatch(t, (Fix)fix);
    }
}

