/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableListMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.Map;
import javax.lang.model.element.Modifier;

@BugPattern(altNames={"mutable"}, summary="AutoValue recommends using immutable collections", severity=BugPattern.SeverityLevel.WARNING, documentSuppression=false)
public class AutoValueImmutableFields
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final ImmutableListMultimap<String, Matcher<MethodTree>> REPLACEMENT_TO_MATCHERS = ((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)((ImmutableListMultimap.Builder)ImmutableListMultimap.builder().put("ImmutableCollection", AutoValueImmutableFields.returning("java.util.Collection"))).putAll((Object)"ImmutableList", new Matcher[]{Matchers.methodReturns(Matchers.isArrayType()), AutoValueImmutableFields.returning("java.util.List"), AutoValueImmutableFields.returning("java.util.ArrayList"), AutoValueImmutableFields.returning("java.util.LinkedList"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableList.Builder")})).putAll((Object)"ImmutableMap", new Matcher[]{AutoValueImmutableFields.returning("java.util.Map"), AutoValueImmutableFields.returning("java.util.HashMap"), AutoValueImmutableFields.returning("java.util.LinkedHashMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableMap.Builder")})).putAll((Object)"ImmutableSortedMap", new Matcher[]{AutoValueImmutableFields.returning("java.util.SortedMap"), AutoValueImmutableFields.returning("java.util.TreeMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSortedMap.Builder")})).putAll((Object)"ImmutableBiMap", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.BiMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableBiMap.Builder")})).putAll((Object)"ImmutableSet", new Matcher[]{AutoValueImmutableFields.returning("java.util.Set"), AutoValueImmutableFields.returning("java.util.HashSet"), AutoValueImmutableFields.returning("java.util.LinkedHashSet"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSet.Builder")})).putAll((Object)"ImmutableSortedSet", new Matcher[]{AutoValueImmutableFields.returning("java.util.SortedSet"), AutoValueImmutableFields.returning("java.util.TreeSet"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSortedSet.Builder")})).putAll((Object)"ImmutableMultimap", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.Multimap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableMultimap.Builder")})).putAll((Object)"ImmutableListMultimap", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.ListMultimap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableListMultimap.Builder")})).putAll((Object)"ImmutableSetMultimap", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.SetMultimap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSetMultimap.Builder")})).putAll((Object)"ImmutableMultiset", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.Multiset"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableMultiset.Builder")})).putAll((Object)"ImmutableSortedMultiset", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.SortedMultiset"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableSortedMultiset.Builder")})).putAll((Object)"ImmutableTable", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.Table"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableTable.Builder")})).putAll((Object)"ImmutableRangeMap", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.RangeMap"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableRangeMap.Builder")})).putAll((Object)"ImmutableRangeSet", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.RangeSet"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutableRangeSet.Builder")})).putAll((Object)"ImmutablePrefixTrie", new Matcher[]{AutoValueImmutableFields.returning("com.google.common.collect.PrefixTrie"), AutoValueImmutableFields.returning("com.google.common.collect.ImmutablePrefixTrie.Builder")})).build();
    private static final Matcher<MethodTree> ABSTRACT_MATCHER = Matchers.hasModifier(Modifier.ABSTRACT);

    private static Matcher<MethodTree> returning(String type) {
        return Matchers.methodReturns(Suppliers.typeFromString(type));
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ASTHelpers.hasAnnotation((Tree)tree, "com.google.auto.value.AutoValue", state)) {
            for (Tree tree2 : tree.getMembers()) {
                MethodTree methodTree;
                if (!(tree2 instanceof MethodTree) || this.isSuppressed(tree2, state) || !ABSTRACT_MATCHER.matches(methodTree = (MethodTree)tree2, state)) continue;
                for (Map.Entry entry : REPLACEMENT_TO_MATCHERS.entries()) {
                    if (!((Matcher)entry.getValue()).matches(methodTree, state)) continue;
                    state.reportMatch(this.buildDescription(methodTree).setMessage(String.format("AutoValue instances should be deeply immutable. Therefore, we recommend returning %s instead.", entry.getKey())).build());
                }
            }
        }
        return Description.NO_MATCH;
    }
}

