/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;

@BugPattern(summary="new BigDecimal(double) loses precision in this case.", severity=BugPattern.SeverityLevel.WARNING)
public class BigDecimalLiteralDouble
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger LONG_MIN = BigInteger.valueOf(Long.MIN_VALUE);
    private static final String BIG_DECIMAL = BigDecimal.class.getName();
    private static final Matcher<ExpressionTree> BIGDECIMAL_DOUBLE_CONSTRUCTOR = Matchers.constructor().forClass(BIG_DECIMAL).withParameters("double", new String[0]);

    private static boolean floatingPointArgument(ExpressionTree tree) {
        if (tree.getKind() == Tree.Kind.UNARY_PLUS || tree.getKind() == Tree.Kind.UNARY_MINUS) {
            tree = ((UnaryTree)tree).getExpression();
        }
        return tree.getKind() == Tree.Kind.DOUBLE_LITERAL || tree.getKind() == Tree.Kind.FLOAT_LITERAL;
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!BIGDECIMAL_DOUBLE_CONSTRUCTOR.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree arg = Iterables.getOnlyElement(tree.getArguments());
        if (!BigDecimalLiteralDouble.floatingPointArgument(arg)) {
            return Description.NO_MATCH;
        }
        return this.createDescription(arg, state);
    }

    private Description createDescription(ExpressionTree arg, VisitorState state) {
        BigDecimal intendedValue;
        Number literalNumber = ASTHelpers.constValue(arg, Number.class);
        if (literalNumber == null) {
            return Description.NO_MATCH;
        }
        double literal = literalNumber.doubleValue();
        String literalString = state.getSourceForNode(arg).replaceAll("[_dDfF]", "");
        try {
            intendedValue = new BigDecimal(literalString);
        }
        catch (ArithmeticException e) {
            return Description.NO_MATCH;
        }
        BigDecimal actualValue = new BigDecimal(literal);
        if (actualValue.compareTo(intendedValue) == 0) {
            return Description.NO_MATCH;
        }
        Optional<BigInteger> integralValue = BigDecimalLiteralDouble.asBigInteger(intendedValue);
        if (integralValue.map(BigDecimalLiteralDouble::isWithinLongRange).orElse(false).booleanValue()) {
            long longValue = integralValue.get().longValue();
            return this.suggestReplacement(arg, actualValue, String.format("%sL", longValue));
        }
        return this.suggestReplacement(arg, actualValue, String.format("\"%s\"", literalString));
    }

    private Description suggestReplacement(ExpressionTree tree, BigDecimal actualValue, String replacement) {
        return this.buildDescription(tree).setMessage(this.message() + String.format(" The exact value here is `new BigDecimal(\"%s\")`.", actualValue)).addFix(SuggestedFix.replace(tree, replacement)).build();
    }

    private static Optional<BigInteger> asBigInteger(BigDecimal v) {
        try {
            return Optional.of(v.toBigIntegerExact());
        }
        catch (ArithmeticException e) {
            return Optional.empty();
        }
    }

    private static boolean isWithinLongRange(BigInteger v) {
        return LONG_MIN.compareTo(v) <= 0 && v.compareTo(LONG_MAX) <= 0;
    }
}

