/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="Comparison using reference equality instead of value equality. Reference equality of boxed primitive types is usually not useful, as they are value objects, and it is bug-prone, as instances are cached for some values but not others.", altNames={"NumericEquality"}, severity=BugPattern.SeverityLevel.ERROR)
public final class BoxedPrimitiveEquality
extends AbstractReferenceEquality {
    private final boolean handleNumber;
    private static final Supplier<Type> JAVA_LANG_NUMBER = VisitorState.memoize(state -> state.getTypeFromString("java.lang.Number"));

    public BoxedPrimitiveEquality(ErrorProneFlags flags) {
        this.handleNumber = flags.getBoolean("BoxedPrimitiveEquality:HandleNumber").orElse(true);
    }

    @Override
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        if (type == null || !this.isRelevantType(type, state)) {
            return false;
        }
        return !BoxedPrimitiveEquality.isStaticConstant(ASTHelpers.getSymbol(tree));
    }

    private boolean isRelevantType(Type type, VisitorState state) {
        if (this.handleNumber && ASTHelpers.isSubtype(type, JAVA_LANG_NUMBER.get(state), state)) {
            return true;
        }
        switch (state.getTypes().unboxedType(type).getTag()) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    private static boolean isStaticConstant(Symbol sym) {
        return sym instanceof Symbol.VarSymbol && BoxedPrimitiveEquality.isFinal(sym) && sym.isStatic();
    }

    public static boolean isFinal(Symbol s) {
        return (s.flags() & 0x10L) == 16L;
    }
}

