/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.nio.ByteBuffer;
import java.util.Optional;

@BugPattern(summary="ByteBuffer.array() shouldn't be called unless ByteBuffer.arrayOffset() is used or if the ByteBuffer was initialized using ByteBuffer.wrap() or ByteBuffer.allocate().", severity=BugPattern.SeverityLevel.WARNING)
public class ByteBufferBackingArray
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> BYTE_BUFFER_ARRAY_MATCHER = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf(ByteBuffer.class.getName()).named("array"));
    private static final Matcher<ExpressionTree> BYTE_BUFFER_ARRAY_OFFSET_MATCHER = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf(ByteBuffer.class.getName()).named("arrayOffset"));
    private static final Matcher<ExpressionTree> BYTE_BUFFER_ALLOWED_INITIALIZERS_MATCHER = Matchers.staticMethod().onClass(ByteBuffer.class.getName()).namedAnyOf("allocate", "wrap");
    private static final Matcher<ExpressionTree> BYTE_BUFFER_MATCHER = Matchers.isSameType(ByteBuffer.class);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        MethodTree enclosingMethod;
        if (!BYTE_BUFFER_ARRAY_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree receiver = tree;
        do {
            if (!ByteBufferBackingArray.isValidInitializerOrNotAByteBuffer(receiver = ASTHelpers.getReceiver(receiver), state)) continue;
            return Description.NO_MATCH;
        } while (receiver instanceof MethodInvocationTree);
        Symbol bufferSymbol = ASTHelpers.getSymbol(receiver);
        if (bufferSymbol == null) {
            return Description.NO_MATCH;
        }
        if (bufferSymbol.owner instanceof Symbol.MethodSymbol && ((enclosingMethod = ASTHelpers.findMethod((Symbol.MethodSymbol)bufferSymbol.owner, state)) == null || ValidByteBufferArrayScanner.scan(enclosingMethod, state, bufferSymbol))) {
            return Description.NO_MATCH;
        }
        if (bufferSymbol.owner instanceof Symbol.ClassSymbol) {
            ClassTree enclosingClass = ASTHelpers.findClass((Symbol.ClassSymbol)bufferSymbol.owner, state);
            if (enclosingClass == null) {
                return Description.NO_MATCH;
            }
            Optional<Tree> validMemberTree = enclosingClass.getMembers().stream().filter(memberTree -> ValidByteBufferArrayScanner.scan(memberTree, state, bufferSymbol)).findFirst();
            if (validMemberTree.isPresent()) {
                return Description.NO_MATCH;
            }
        }
        return this.describeMatch(tree);
    }

    private static boolean isValidInitializerOrNotAByteBuffer(ExpressionTree receiver, VisitorState state) {
        return BYTE_BUFFER_ALLOWED_INITIALIZERS_MATCHER.matches(receiver, state) || !BYTE_BUFFER_MATCHER.matches(receiver, state);
    }

    private static class ValidByteBufferInitializerScanner
    extends TreeScanner<Boolean, VisitorState> {
        static Boolean scan(ExpressionTree tree, VisitorState state) {
            ValidByteBufferInitializerScanner visitor = new ValidByteBufferInitializerScanner();
            return MoreObjects.firstNonNull(tree.accept(visitor, state), false);
        }

        private ValidByteBufferInitializerScanner() {
        }

        @Override
        public Boolean visitMethodInvocation(MethodInvocationTree tree, VisitorState state) {
            boolean b1 = BYTE_BUFFER_ALLOWED_INITIALIZERS_MATCHER.matches(tree, state);
            boolean b2 = (Boolean)super.visitMethodInvocation(tree, state);
            return b1 || b2;
        }

        @Override
        public Boolean reduce(Boolean r1, Boolean r2) {
            return MoreObjects.firstNonNull(r1, false) != false || MoreObjects.firstNonNull(r2, false) != false;
        }
    }

    private static class ValidByteBufferArrayScanner
    extends TreeScanner<Void, VisitorState> {
        private final Symbol searchedBufferSymbol;
        private boolean visited;
        private boolean valid;

        static boolean scan(Tree tree, VisitorState state, Symbol searchedBufferSymbol) {
            ValidByteBufferArrayScanner visitor = new ValidByteBufferArrayScanner(searchedBufferSymbol);
            tree.accept(visitor, state);
            return visitor.valid;
        }

        private ValidByteBufferArrayScanner(Symbol searchedBufferSymbol) {
            this.searchedBufferSymbol = searchedBufferSymbol;
        }

        @Override
        public Void visitVariable(VariableTree tree, VisitorState state) {
            this.checkForInitializer(ASTHelpers.getSymbol(tree), tree.getInitializer(), state);
            return (Void)super.visitVariable(tree, state);
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, VisitorState state) {
            this.checkForInitializer(ASTHelpers.getSymbol(tree.getVariable()), tree.getExpression(), state);
            return (Void)super.visitAssignment(tree, state);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, VisitorState state) {
            if (this.valid) {
                return null;
            }
            Symbol bufferSymbol = ASTHelpers.getSymbol(ASTHelpers.getReceiver(tree));
            if (this.searchedBufferSymbol.equals(bufferSymbol)) {
                if (BYTE_BUFFER_ARRAY_MATCHER.matches(tree, state)) {
                    this.visited = true;
                } else if (BYTE_BUFFER_ARRAY_OFFSET_MATCHER.matches(tree, state)) {
                    this.valid = true;
                }
            }
            return (Void)super.visitMethodInvocation(tree, state);
        }

        private void checkForInitializer(Symbol foundSymbol, ExpressionTree expression, VisitorState state) {
            if (this.visited || this.valid) {
                return;
            }
            if (!this.searchedBufferSymbol.equals(foundSymbol)) {
                return;
            }
            if (expression == null) {
                return;
            }
            if (ValidByteBufferInitializerScanner.scan(expression, state).booleanValue()) {
                this.valid = true;
            }
        }
    }
}

