/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;

@BugPattern(summary="Logging or rethrowing exceptions should usually be preferred to catching and calling printStackTrace", severity=BugPattern.SeverityLevel.WARNING)
public class CatchAndPrintStackTrace
extends BugChecker
implements BugChecker.CatchTreeMatcher {
    private static final Matcher<BlockTree> MATCHER = Matchers.matchSingleStatementBlock(Matchers.expressionStatement(MethodMatchers.instanceMethod().onDescendantOf("java.lang.Throwable").named("printStackTrace")));

    @Override
    public Description matchCatch(CatchTree tree, VisitorState state) {
        if (MATCHER.matches(tree.getBlock(), state)) {
            return this.describeMatch(Iterables.getOnlyElement(tree.getBlock().getStatements()));
        }
        return Description.NO_MATCH;
    }
}

