/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.checkreturnvalue.AutoValueRules;
import com.google.errorprone.bugpatterns.checkreturnvalue.ExternalCanIgnoreReturnValue;
import com.google.errorprone.bugpatterns.checkreturnvalue.PackagesRule;
import com.google.errorprone.bugpatterns.checkreturnvalue.ProtoRules;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicy;
import com.google.errorprone.bugpatterns.checkreturnvalue.ResultUsePolicyEvaluator;
import com.google.errorprone.bugpatterns.checkreturnvalue.Rules;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

@BugPattern(altNames={"ResultOfMethodCallIgnored", "ReturnValueIgnored"}, summary="The result of this call must be used", severity=BugPattern.SeverityLevel.ERROR)
public class CheckReturnValue
extends AbstractReturnValueIgnored
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher {
    private static final String CHECK_RETURN_VALUE = "CheckReturnValue";
    private static final String CAN_IGNORE_RETURN_VALUE = "CanIgnoreReturnValue";
    static final String CHECK_ALL_CONSTRUCTORS = "CheckReturnValue:CheckAllConstructors";
    static final String CHECK_ALL_METHODS = "CheckReturnValue:CheckAllMethods";
    static final String CRV_PACKAGES = "CheckReturnValue:Packages";
    private final MessageTrailerStyle messageTrailerStyle;
    private final Optional<ResultUsePolicy> constructorPolicy;
    private final Optional<ResultUsePolicy> methodPolicy;
    private final ResultUsePolicyEvaluator evaluator;
    private static final String BOTH_ERROR = "@CheckReturnValue and @CanIgnoreReturnValue cannot both be applied to the same %s";

    public CheckReturnValue(ErrorProneFlags flags) {
        super(flags);
        this.messageTrailerStyle = flags.getEnum("CheckReturnValue:MessageTrailerStyle", MessageTrailerStyle.class).orElse(MessageTrailerStyle.NONE);
        this.constructorPolicy = CheckReturnValue.defaultPolicy(flags, CHECK_ALL_CONSTRUCTORS);
        this.methodPolicy = CheckReturnValue.defaultPolicy(flags, CHECK_ALL_METHODS);
        ResultUsePolicyEvaluator.Builder builder = ResultUsePolicyEvaluator.builder().addRules(Rules.mapAnnotationSimpleName(CHECK_RETURN_VALUE, ResultUsePolicy.EXPECTED), Rules.mapAnnotationSimpleName(CAN_IGNORE_RETURN_VALUE, ResultUsePolicy.OPTIONAL), ProtoRules.protoBuilders(), ProtoRules.mutableProtos(), AutoValueRules.autoValues(), AutoValueRules.autoValueBuilders(), AutoValueRules.autoBuilders(), ExternalCanIgnoreReturnValue.externalIgnoreList());
        flags.getList(CRV_PACKAGES).ifPresent(packagePatterns -> builder.addRule(PackagesRule.fromPatterns(packagePatterns)));
        this.evaluator = builder.addRule(Rules.globalDefault(this.methodPolicy, this.constructorPolicy)).build();
    }

    private static Optional<ResultUsePolicy> defaultPolicy(ErrorProneFlags flags, String flag) {
        return flags.getBoolean(flag).map(check -> check != false ? ResultUsePolicy.EXPECTED : ResultUsePolicy.OPTIONAL);
    }

    public Matcher<ExpressionTree> specializedMatcher() {
        return (tree, state) -> CheckReturnValue.methodToInspect(tree).map(method -> this.evaluator.evaluate((Symbol.MethodSymbol)method, state)).orElse(ResultUsePolicy.OPTIONAL).equals((Object)ResultUsePolicy.EXPECTED);
    }

    private static Optional<Symbol.MethodSymbol> methodToInspect(ExpressionTree tree) {
        ClassTree anonymousClazz;
        if (tree instanceof NewClassTree && (anonymousClazz = ((NewClassTree)tree).getClassBody()) != null) {
            Optional<MethodTree> constructor = anonymousClazz.getMembers().stream().filter(MethodTree.class::isInstance).map(MethodTree.class::cast).filter(mt -> ASTHelpers.getSymbol(mt).isConstructor()).findFirst();
            return constructor.map(MethodTree::getBody).map(block -> block.getStatements().get(0)).map(ExpressionStatementTree.class::cast).map(ExpressionStatementTree::getExpression).map(MethodInvocationTree.class::cast).map(ASTHelpers::getSymbol);
        }
        return CheckReturnValue.methodSymbol(tree);
    }

    private static Optional<Symbol.MethodSymbol> methodSymbol(ExpressionTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym instanceof Symbol.MethodSymbol ? Optional.of((Symbol.MethodSymbol)sym) : Optional.empty();
    }

    @Override
    public boolean isCovered(ExpressionTree tree, VisitorState state) {
        return CheckReturnValue.methodToInspect(tree).stream().flatMap(method -> this.evaluator.evaluations((Symbol.MethodSymbol)method, state)).findFirst().isPresent();
    }

    @Override
    public ImmutableMap<String, ?> getMatchMetadata(ExpressionTree tree, VisitorState state) {
        return CheckReturnValue.methodToInspect(tree).stream().flatMap(method -> this.evaluator.evaluations((Symbol.MethodSymbol)method, state)).findFirst().map(evaluation -> ImmutableMap.of("rule", evaluation.rule(), "policy", evaluation.policy(), "scope", evaluation.scope())).orElse(ImmutableMap.of());
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        String annotationToValidate;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(tree);
        boolean checkReturn = ASTHelpers.hasDirectAnnotationWithSimpleName(method, CHECK_RETURN_VALUE);
        boolean canIgnore = ASTHelpers.hasDirectAnnotationWithSimpleName(method, CAN_IGNORE_RETURN_VALUE);
        if (checkReturn && canIgnore) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "method")).build();
        }
        if (checkReturn) {
            annotationToValidate = CHECK_RETURN_VALUE;
        } else if (canIgnore) {
            annotationToValidate = CAN_IGNORE_RETURN_VALUE;
        } else {
            return Description.NO_MATCH;
        }
        if (method.getKind() != ElementKind.METHOD) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isVoidType(method.getReturnType(), state)) {
            return Description.NO_MATCH;
        }
        String message = String.format("@%s may not be applied to void-returning methods", annotationToValidate);
        return this.buildDescription(tree).setMessage(message).build();
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (ASTHelpers.hasDirectAnnotationWithSimpleName(ASTHelpers.getSymbol(tree), CHECK_RETURN_VALUE) && ASTHelpers.hasDirectAnnotationWithSimpleName(ASTHelpers.getSymbol(tree), CAN_IGNORE_RETURN_VALUE)) {
            return this.buildDescription(tree).setMessage(String.format(BOTH_ERROR, "class")).build();
        }
        return Description.NO_MATCH;
    }

    private Description describeInvocationResultIgnored(Tree tree, String shortCall, String shortCallWithoutNew, Symbol.MethodSymbol symbol, Fix fix, VisitorState state) {
        String message = String.format("The result of `%s` must be used\nIf you really don't want to use the result, then assign it to a variable: `var unused = ...`.\n\nIf callers of `%s` shouldn't be required to use its result, then annotate it with `@CanIgnoreReturnValue`.\n%s", shortCall, shortCallWithoutNew, this.apiTrailer(symbol, state));
        return this.buildDescription(tree).addFix(fix).setMessage(message).build();
    }

    @Override
    protected Description describeReturnValueIgnored(MethodInvocationTree tree, VisitorState state) {
        String shortCall;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        String shortCallWithoutNew = shortCall = symbol.name + (tree.getArguments().isEmpty() ? "()" : "(...)");
        return this.describeInvocationResultIgnored(tree, shortCall, shortCallWithoutNew, symbol, this.makeFix(tree, state), state);
    }

    @Override
    protected Description describeReturnValueIgnored(NewClassTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        String shortCallWithoutNew = state.getSourceForNode(tree.getIdentifier()) + (tree.getArguments().isEmpty() ? "()" : "(...)");
        String shortCall = "new " + shortCallWithoutNew;
        return this.describeInvocationResultIgnored(tree, shortCall, shortCallWithoutNew, symbol, SuggestedFix.emptyFix(), state);
    }

    @Override
    protected Description describeReturnValueIgnored(MemberReferenceTree tree, VisitorState state) {
        String shortCall;
        String shortCallWithoutNew;
        String parensAndMaybeEllipsis;
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        Type type = state.getTypes().memberType(ASTHelpers.getType(tree.getQualifierExpression()), symbol);
        String string = parensAndMaybeEllipsis = type instanceof Type.MethodType && ((List)((Type.MethodType)type).getParameterTypes()).isEmpty() ? "()" : "(...)";
        if (tree.getMode() == MemberReferenceTree.ReferenceMode.NEW) {
            shortCallWithoutNew = state.getSourceForNode(tree.getQualifierExpression()) + parensAndMaybeEllipsis;
            shortCall = "new " + (String)shortCallWithoutNew;
        } else {
            shortCall = shortCallWithoutNew = tree.getName() + parensAndMaybeEllipsis;
        }
        String implementedMethod = (Name)ASTHelpers.getType(tree).asElement().getSimpleName() + "." + state.getTypes().findDescriptorSymbol(ASTHelpers.getType(tree).asElement()).getSimpleName();
        String methodReference = state.getSourceForNode(tree);
        String message = String.format("The result of `%s` must be used\n`%s` acts as an implementation of `%s`.\n\u2014 which is a `void` method, so it doesn't use the result of `%s`.\n\nTo use the result, you may need to restructure your code.\n\nIf you really don't want to use the result, then switch to a lambda that assigns it to a variable: `%s -> { var unused = ...; }`.\n\nIf callers of `%s` shouldn't be required to use its result, then annotate it with `@CanIgnoreReturnValue`.\n%s", shortCall, methodReference, implementedMethod, shortCall, parensAndMaybeEllipsis, shortCallWithoutNew, this.apiTrailer(symbol, state));
        return this.buildDescription(tree).setMessage(message).build();
    }

    private String apiTrailer(Symbol.MethodSymbol symbol, VisitorState state) {
        if (symbol.enclClass().isAnonymous()) {
            return "";
        }
        switch (this.messageTrailerStyle) {
            case NONE: {
                return "";
            }
            case API_ERASED_SIGNATURE: {
                return "\n\nFull API: " + ExternalCanIgnoreReturnValue.surroundingClass(symbol) + "#" + ExternalCanIgnoreReturnValue.methodNameAndParams(symbol, state.getTypes());
            }
        }
        throw new AssertionError();
    }

    static enum MessageTrailerStyle {
        NONE,
        API_ERASED_SIGNATURE;

    }
}

