/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;

@BugPattern(summary="The result of #compareTo or #compare should only be compared to 0. It is an implementation detail whether a given type returns strictly the values {-1, 0, +1} or others.", severity=BugPattern.SeverityLevel.WARNING)
public final class CompareToZero
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String SUGGEST_IMPROVEMENT = "It is generally more robust (and readable) to compare the result of #compareTo/#compare to0. Although the suggested replacement is identical in this case, we'd suggest it forconsistency.";
    private static final ImmutableSet<Tree.Kind> COMPARISONS = ImmutableSet.of(Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO, Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_EQUAL, new Tree.Kind[0]);
    private static final ImmutableMap<Tree.Kind, Tree.Kind> REVERSE = ImmutableMap.of(Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.GREATER_THAN, Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.LESS_THAN_EQUAL);
    private static final ImmutableSet<Tree.Kind> OTHER_STRANGE_OPERATIONS = ImmutableSet.of(Tree.Kind.PLUS, Tree.Kind.MINUS);
    private static final Matcher<ExpressionTree> COMPARE_TO = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("java.lang.Comparable").named("compareTo"), MethodMatchers.instanceMethod().onDescendantOf("java.util.Comparator").named("compare"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (COMPARE_TO.matches(tree, state)) {
            new Visitor().visitParent(state);
        }
        return Description.NO_MATCH;
    }

    private final class Visitor
    extends SimpleTreeVisitor<Void, VisitorState> {
        private Tree child;

        private Visitor() {
        }

        @Override
        public Void visitParenthesized(ParenthesizedTree parenthesizedTree, VisitorState state) {
            return this.visitParent(state);
        }

        @Override
        public Void visitBinary(BinaryTree binaryTree, VisitorState state) {
            ExpressionTree otherSide;
            Tree.Kind kind = binaryTree.getKind();
            boolean reversed = binaryTree.getRightOperand() == this.child;
            ExpressionTree comparatorSide = reversed ? binaryTree.getRightOperand() : binaryTree.getLeftOperand();
            ExpressionTree expressionTree = otherSide = reversed ? binaryTree.getLeftOperand() : binaryTree.getRightOperand();
            if (OTHER_STRANGE_OPERATIONS.contains((Object)kind)) {
                if (!kind.equals((Object)Tree.Kind.PLUS) || !ASTHelpers.isSameType(ASTHelpers.getType(otherSide), state.getSymtab().stringType, state)) {
                    state.reportMatch(CompareToZero.this.describeMatch(binaryTree));
                }
                return null;
            }
            Integer constantInt = ASTHelpers.constValue(otherSide, Integer.class);
            if (constantInt == null) {
                return null;
            }
            if (constantInt == 0) {
                return null;
            }
            if (binaryTree.getKind() == Tree.Kind.EQUAL_TO) {
                SuggestedFix fix = this.generateFix(binaryTree, state, comparatorSide, constantInt < 0 ? "<" : ">");
                state.reportMatch(CompareToZero.this.describeMatch(binaryTree, (Fix)fix));
                return null;
            }
            if (reversed) {
                kind = REVERSE.get((Object)kind);
            }
            if (kind == null) {
                return null;
            }
            if ((kind == Tree.Kind.GREATER_THAN || kind == Tree.Kind.NOT_EQUAL_TO) && constantInt == -1) {
                SuggestedFix fix = this.generateFix(binaryTree, state, comparatorSide, ">=");
                state.reportMatch(CompareToZero.this.describeMatch(binaryTree, (Fix)fix));
                return null;
            }
            if ((kind == Tree.Kind.LESS_THAN || kind == Tree.Kind.NOT_EQUAL_TO) && constantInt == 1) {
                SuggestedFix fix = this.generateFix(binaryTree, state, comparatorSide, "<=");
                state.reportMatch(CompareToZero.this.describeMatch(binaryTree, (Fix)fix));
                return null;
            }
            if (kind == Tree.Kind.LESS_THAN_EQUAL && constantInt == -1) {
                SuggestedFix fix = this.generateFix(binaryTree, state, comparatorSide, "<");
                state.reportMatch(CompareToZero.this.buildDescription(binaryTree).setMessage(CompareToZero.SUGGEST_IMPROVEMENT).addFix(fix).build());
                return null;
            }
            if (kind == Tree.Kind.GREATER_THAN_EQUAL && constantInt == 1) {
                SuggestedFix fix = this.generateFix(binaryTree, state, comparatorSide, ">");
                state.reportMatch(CompareToZero.this.buildDescription(binaryTree).setMessage(CompareToZero.SUGGEST_IMPROVEMENT).addFix(fix).build());
                return null;
            }
            if (COMPARISONS.contains((Object)binaryTree.getKind())) {
                state.reportMatch(CompareToZero.this.describeMatch(binaryTree));
            }
            return null;
        }

        private SuggestedFix generateFix(BinaryTree binaryTree, VisitorState state, ExpressionTree comparatorSide, String comparator) {
            return SuggestedFix.replace(binaryTree, String.format("%s %s 0", state.getSourceForNode(comparatorSide), comparator));
        }

        private Void visitParent(VisitorState state) {
            this.child = state.getPath().getLeaf();
            TreePath parentPath = state.getPath().getParentPath();
            return (Void)this.visit(parentPath.getLeaf(), state.withPath(parentPath));
        }
    }
}

