/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Name;

@BugPattern(summary="computeIfAbsent passes the map key to the provided class's constructor", severity=BugPattern.SeverityLevel.ERROR)
public final class ComputeIfAbsentAmbiguousReference
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> COMPUTE_IF_ABSENT = MethodMatchers.instanceMethod().onDescendantOf("java.util.Map").named("computeIfAbsent");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!COMPUTE_IF_ABSENT.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree mappingFunctionArg = tree.getArguments().get(1);
        if (!(mappingFunctionArg instanceof MemberReferenceTree)) {
            return Description.NO_MATCH;
        }
        MemberReferenceTree memberReferenceTree = (MemberReferenceTree)mappingFunctionArg;
        if (memberReferenceTree.getMode() != MemberReferenceTree.ReferenceMode.NEW) {
            return Description.NO_MATCH;
        }
        ExpressionTree expressionTree = memberReferenceTree.getQualifierExpression();
        Symbol symbol = ASTHelpers.getSymbol(expressionTree);
        if (!(symbol instanceof Symbol.ClassSymbol)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
        ImmutableList<Symbol.MethodSymbol> constructors = ASTHelpers.getConstructors(classSymbol);
        java.util.List zeroArgConstructors = constructors.stream().filter(methodSymbol -> methodSymbol.type.getParameterTypes().isEmpty()).collect(Collectors.toList());
        if (zeroArgConstructors.size() != 1) {
            return Description.NO_MATCH;
        }
        java.util.List oneArgConstructors = constructors.stream().filter(methodSymbol -> methodSymbol.type.getParameterTypes().size() == 1).collect(Collectors.toList());
        if (oneArgConstructors.isEmpty()) {
            return Description.NO_MATCH;
        }
        ExpressionTree onlyArgument = tree.getArguments().get(0);
        if (onlyArgument instanceof IdentifierTree) {
            IdentifierTree onlyArgumentIdentifier = (IdentifierTree)onlyArgument;
            Name constructorParamName = ((Symbol.VarSymbol)((List)((Symbol.MethodSymbol)oneArgConstructors.get(0)).getParameters()).get(0)).getSimpleName();
            if (((Object)constructorParamName).equals(onlyArgumentIdentifier.getName())) {
                return Description.NO_MATCH;
            }
        }
        return this.describeMatch(memberReferenceTree);
    }
}

