/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="A conditional expression with numeric operands of differing types will perform binary numeric promotion of the operands; when these operands are of reference types, the expression's result may not be of the expected type.", severity=BugPattern.SeverityLevel.ERROR)
public class ConditionalExpressionNumericPromotion
extends BugChecker
implements BugChecker.ConditionalExpressionTreeMatcher {
    private static final Supplier<Type> JAVA_LANG_NUMBER = VisitorState.memoize(state -> state.getTypeFromString("java.lang.Number"));

    @Override
    public Description matchConditionalExpression(ConditionalExpressionTree conditionalExpression, VisitorState state) {
        Type expressionType = Preconditions.checkNotNull(ASTHelpers.getType(conditionalExpression));
        if (!expressionType.isPrimitive()) {
            return Description.NO_MATCH;
        }
        ExpressionTree trueExpression = conditionalExpression.getTrueExpression();
        ExpressionTree falseExpression = conditionalExpression.getFalseExpression();
        Type trueType = Preconditions.checkNotNull(ASTHelpers.getType(trueExpression));
        Type falseType = Preconditions.checkNotNull(ASTHelpers.getType(falseExpression));
        if (trueType.isPrimitive() || falseType.isPrimitive()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isSameType(trueType, falseType, state)) {
            return Description.NO_MATCH;
        }
        ASTHelpers.TargetType targetType = ASTHelpers.targetType(state);
        if (targetType == null) {
            return Description.NO_MATCH;
        }
        if (targetType.type().isPrimitive()) {
            return Description.NO_MATCH;
        }
        Type numberType = JAVA_LANG_NUMBER.get(state);
        if (ASTHelpers.isSubtype(targetType.type(), numberType, state) && !ASTHelpers.isSameType(targetType.type(), numberType, state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        String numberName = SuggestedFixes.qualifyType(state, builder, numberType);
        String prefix = "((" + numberName + ") ";
        builder.prefixWith(trueExpression, prefix).postfixWith(trueExpression, ")");
        builder.prefixWith(falseExpression, prefix).postfixWith(falseExpression, ")");
        return this.describeMatch(conditionalExpression, (Fix)builder.build());
    }
}

