/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashBasedTable;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@BugPattern(summary="This expression was previously declared as a constant; consider replacing this occurrence.", severity=BugPattern.SeverityLevel.ERROR)
public class DeduplicateConstants
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final HashBasedTable fixes = HashBasedTable.create();
        new TreeScanner<Void, Scope>(){

            @Override
            public Void visitBlock(BlockTree tree, Scope scope) {
                return (Void)super.visitBlock(tree, scope.enter());
            }

            @Override
            public Void visitVariable(VariableTree tree, Scope scope) {
                scope.remove(ASTHelpers.getSymbol(tree));
                this.scan(tree.getInitializer(), scope);
                this.saveConstValue(tree, scope);
                return null;
            }

            @Override
            public Void visitLiteral(LiteralTree tree, Scope scope) {
                this.replaceLiteral(tree, scope, state);
                return (Void)super.visitLiteral(tree, scope);
            }

            private void replaceLiteral(LiteralTree tree, Scope scope, VisitorState state2) {
                Object value = ASTHelpers.constValue(tree);
                if (value == null) {
                    return;
                }
                Symbol.VarSymbol sym = scope.get(state2.getSourceForNode(tree));
                if (sym == null) {
                    return;
                }
                SuggestedFix fix = SuggestedFix.replace(tree, ((Name)sym.getSimpleName()).toString());
                fixes.put(sym, tree, fix);
            }

            private void saveConstValue(VariableTree tree, Scope scope) {
                Symbol.VarSymbol sym = ASTHelpers.getSymbol(tree);
                if (!ASTHelpers.isConsideredFinal(sym)) {
                    return;
                }
                String constValue = ASTHelpers.constValue(tree.getInitializer(), String.class);
                if (constValue == null || constValue.length() <= 1) {
                    return;
                }
                scope.put(state.getSourceForNode(tree.getInitializer()), sym);
            }
        }.scan(tree, new Scope(null));
        for (Map.Entry entries : fixes.rowMap().entrySet()) {
            Map occurrences = entries.getValue();
            if (occurrences.size() < 2) continue;
            SuggestedFix fix = DeduplicateConstants.mergeFix(occurrences.values());
            occurrences.keySet().forEach(t -> state.reportMatch(this.describeMatch((Tree)t, (Fix)fix)));
        }
        return Description.NO_MATCH;
    }

    private static SuggestedFix mergeFix(Collection<SuggestedFix> fixes) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        fixes.forEach(fix::merge);
        return fix.build();
    }

    static class Scope {
        private final HashMap<String, Symbol.VarSymbol> values = new HashMap();
        private final Set<Name> hidden = new HashSet<Name>();
        private final Scope parent;

        Scope(Scope parent) {
            this.parent = parent;
        }

        Scope enter() {
            return new Scope(this);
        }

        @Nullable
        public Symbol.VarSymbol get(String value) {
            Symbol.VarSymbol sym = this.getInternal(value);
            if (sym == null) {
                return null;
            }
            if (this.hidden.contains(sym.getSimpleName())) {
                return null;
            }
            return sym;
        }

        @Nullable
        private Symbol.VarSymbol getInternal(String value) {
            Symbol.VarSymbol sym = this.values.get(value);
            if (sym != null) {
                return sym;
            }
            if (this.parent != null && (sym = this.parent.get(value)) != null) {
                return sym;
            }
            return null;
        }

        public void put(String value, Symbol.VarSymbol sym) {
            this.hidden.remove(sym.getSimpleName());
            this.values.put(value, sym);
        }

        public void remove(Symbol.VarSymbol sym) {
            this.hidden.add((Name)sym.getSimpleName());
        }
    }
}

