/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(altNames={"dep-ann"}, summary="Item documented with a @deprecated javadoc note is not annotated with @Deprecated", severity=BugPattern.SeverityLevel.ERROR)
public class DepAnn
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.ClassTreeMatcher,
BugChecker.VariableTreeMatcher {
    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        return this.checkDeprecatedAnnotation(methodTree, state);
    }

    @Override
    public Description matchClass(ClassTree classTree, VisitorState state) {
        return this.checkDeprecatedAnnotation(classTree, state);
    }

    @Override
    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        return this.checkDeprecatedAnnotation(variableTree, state);
    }

    private Description checkDeprecatedAnnotation(Tree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol(tree);
        if ((symbol.flags() & 0x20000L) == 0L) {
            return Description.NO_MATCH;
        }
        if (symbol.attribute(state.getSymtab().deprecatedType.tsym) != null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.prefixWith(tree, "@Deprecated\n"));
    }
}

