/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;

@BugPattern(summary="Methods should not be directly invoked on mocks. Should this be part of a verify(..) call?", severity=BugPattern.SeverityLevel.WARNING)
public final class DirectInvocationOnMock
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> MOCK = Matchers.staticMethod().onClass("org.mockito.Mockito").named("mock").withParameters("java.lang.Class", new String[0]);
    private static final Matcher<MethodInvocationTree> DO_CALL_REAL_METHOD = Matchers.allOf(Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.Stubber").named("when"), Matchers.receiverOfInvocation(Matchers.staticMethod().onClass("org.mockito.Mockito").named("doCallRealMethod")));
    private static final Matcher<ExpressionTree> WHEN = Matchers.anyMethod().anyClass().named("when");
    private static final Matcher<ExpressionTree> THEN_CALL_REAL_METHOD = Matchers.instanceMethod().onDescendantOf("org.mockito.stubbing.OngoingStubbing").named("thenCallRealMethod");

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableSet<Symbol.VarSymbol> mocks = this.findMocks(state);
        final HashSet methodsCallingRealImplementations = new HashSet();
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (THEN_CALL_REAL_METHOD.matches(tree, state)) {
                    ExpressionTree firstArgument;
                    Symbol firstArgumentSymbol;
                    ExpressionTree receiver = ASTHelpers.getReceiver(tree);
                    if (receiver != null && WHEN.matches(receiver, state) && (firstArgumentSymbol = ASTHelpers.getSymbol(firstArgument = ((MethodInvocationTree)receiver).getArguments().get(0))) instanceof Symbol.MethodSymbol) {
                        methodsCallingRealImplementations.add((Symbol.MethodSymbol)firstArgumentSymbol);
                    }
                    return (Void)super.visitMethodInvocation(tree, null);
                }
                if (DO_CALL_REAL_METHOD.matches(tree, state)) {
                    Symbol methodSymbol = ASTHelpers.getSymbol(this.getCurrentPath().getParentPath().getParentPath().getLeaf());
                    if (methodSymbol instanceof Symbol.MethodSymbol) {
                        methodsCallingRealImplementations.add((Symbol.MethodSymbol)methodSymbol);
                    }
                    return (Void)super.visitMethodInvocation(tree, null);
                }
                if (methodsCallingRealImplementations.contains(ASTHelpers.getSymbol(tree))) {
                    return (Void)super.visitMethodInvocation(tree, null);
                }
                if ((ASTHelpers.getSymbol(tree).flags() & 0x10L) != 0L) {
                    return null;
                }
                Tree parent = Streams.stream(this.getCurrentPath()).skip(1L).filter(t -> !(t instanceof TypeCastTree)).findFirst().get();
                ExpressionTree receiver = ASTHelpers.getReceiver(tree);
                if (!(!this.isMock(receiver) || parent instanceof ExpressionTree && WHEN.matches((ExpressionTree)parent, state))) {
                    Description.Builder description = DirectInvocationOnMock.this.buildDescription(tree).setMessage(String.format("Methods should not be directly invoked on the mock `%s`. Should this be part of a verify(..) call?", ASTHelpers.getSymbol(receiver).getSimpleName()));
                    if (this.getCurrentPath().getParentPath().getLeaf() instanceof ExpressionStatementTree) {
                        SuggestedFix.Builder fix = SuggestedFix.builder();
                        String verify = SuggestedFixes.qualifyStaticImport("org.mockito.Mockito.verify", fix, state);
                        description.addFix(fix.replace(receiver, String.format("%s(%s)", verify, state.getSourceForNode(receiver))).setShortDescription("turn into verify() call").build());
                        description.addFix(SuggestedFix.builder().delete(tree).setShortDescription("delete redundant invocation").build());
                    }
                    state.reportMatch(description.build());
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }

            private boolean isMock(ExpressionTree tree) {
                Symbol symbol = ASTHelpers.getSymbol(tree);
                return symbol != null && (mocks.contains(symbol) || symbol.getAnnotationMirrors().stream().filter(am -> am.type.tsym.getQualifiedName().contentEquals("org.mockito.Mock")).findFirst().filter(am -> MoreAnnotations.getAnnotationValue(am, "answer").isEmpty()).isPresent());
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private ImmutableSet<Symbol.VarSymbol> findMocks(final VisitorState state) {
        final ImmutableSet.Builder mocks = ImmutableSet.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                if (tree.getInitializer() != null && MOCK.matches(tree.getInitializer(), state)) {
                    mocks.add(ASTHelpers.getSymbol(tree));
                }
                return (Void)super.visitVariable(tree, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                Symbol symbol;
                if (MOCK.matches(tree.getExpression(), state) && (symbol = ASTHelpers.getSymbol(tree.getVariable())) instanceof Symbol.VarSymbol) {
                    mocks.add((Symbol.VarSymbol)symbol);
                }
                return (Void)super.visitAssignment(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return mocks.build();
    }
}

