/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Consider annotating methods that always throw with @DoNotCall. Read more at https://errorprone.info/bugpattern/DoNotCall", severity=BugPattern.SeverityLevel.WARNING)
public class DoNotCallSuggester
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final ImmutableSet<String> METHOD_PREFIXES_TO_IGNORE = ImmutableSet.of("produce", "provide");
    private static final ImmutableSet<String> METHOD_SUBSTRINGS_TO_IGNORE = ImmutableSet.of("throw", "fail", "exception", "propagate");
    private static final ImmutableSet<String> ANNOTATIONS_TO_IGNORE = ImmutableSet.of("com.google.errorprone.annotations.DoNotCall", "java.lang.Override", "dagger.Provides", "dagger.producers.Produces", "net.starlark.java.annot.StarlarkMethod");
    private static final ImmutableSet<String> PARENT_CLASS_TO_IGNORE = ImmutableSet.of("com.google.inject.AbstractModule");
    private static final ImmutableSet<String> RETURNED_SUPER_TYPES_TO_IGNORE = ImmutableSet.of("java.lang.Throwable");

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(tree);
        if (tree.getBody() == null) {
            return Description.NO_MATCH;
        }
        if (tree.getBody().getStatements().size() != 1) {
            return Description.NO_MATCH;
        }
        if (symbol.getModifiers().contains((Object)Modifier.PRIVATE) || ASTHelpers.methodCanBeOverridden(symbol)) {
            return Description.NO_MATCH;
        }
        StatementTree statement = Iterables.getOnlyElement(tree.getBody().getStatements());
        if (!(statement instanceof ThrowTree)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol enclosingClass = ASTHelpers.enclosingClass(symbol);
        Type.ClassType enclosingType = ASTHelpers.getType(ASTHelpers.findClass(enclosingClass, state));
        for (String string : PARENT_CLASS_TO_IGNORE) {
            Type type = state.getTypeFromString(string);
            if (!ASTHelpers.isSubtype(enclosingType, type, state)) continue;
            return Description.NO_MATCH;
        }
        if (enclosingClass.isAnonymous()) {
            return Description.NO_MATCH;
        }
        String methodName = tree.getName().toString().toLowerCase();
        for (String string : METHOD_PREFIXES_TO_IGNORE) {
            if (!methodName.startsWith(string)) continue;
            return Description.NO_MATCH;
        }
        for (String string : METHOD_SUBSTRINGS_TO_IGNORE) {
            if (!methodName.contains(string)) continue;
            return Description.NO_MATCH;
        }
        for (String string : ANNOTATIONS_TO_IGNORE) {
            if (!ASTHelpers.hasAnnotation((Tree)tree, string, state)) continue;
            return Description.NO_MATCH;
        }
        Type type = ASTHelpers.getType(tree.getReturnType());
        for (String returnedSuperType : RETURNED_SUPER_TYPES_TO_IGNORE) {
            Type throwableType = state.getTypeFromString(returnedSuperType);
            if (!ASTHelpers.isSubtype(type, throwableType, state)) continue;
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.findSuperMethods(symbol, state.getTypes()).isEmpty()) {
            return Description.NO_MATCH;
        }
        Type type2 = ASTHelpers.getType(((ThrowTree)statement).getExpression());
        SuggestedFix fix = SuggestedFix.builder().addImport("com.google.errorprone.annotations.DoNotCall").prefixWith(tree, "@DoNotCall(\"Always throws " + type2 + "\") ").build();
        return this.buildDescription(tree).setMessage("Methods that always throw an exception should be annotated with @DoNotCall to prevent calls at compilation time vs. at runtime (note that adding @DoNotCall will break any existing callers of this API).").addFix(fix).build();
    }
}

