/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;

@BugPattern(summary="Caught exceptions should not be ignored", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, documentSuppression=false, linkType=BugPattern.LinkType.CUSTOM, link="https://google.github.io/styleguide/javaguide.html#s6.2-caught-exceptions")
public class EmptyCatch
extends BugChecker
implements BugChecker.CatchTreeMatcher {
    @Override
    public Description matchCatch(CatchTree tree, VisitorState state) {
        BlockTree block = tree.getBlock();
        if (!block.getStatements().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (state.getTokensForNode(block).stream().anyMatch(t -> !t.comments().isEmpty())) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isJUnitTestCode(state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.isTestNgTestCode(state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

