/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;

@BugPattern(name="EmptyIf", altNames={"empty"}, summary="Empty statement after if", severity=BugPattern.SeverityLevel.ERROR)
public class EmptyIfStatement
extends BugChecker
implements BugChecker.EmptyStatementTreeMatcher {
    @Override
    public Description matchEmptyStatement(EmptyStatementTree tree, VisitorState state) {
        TreePath parentPath = state.getPath().getParentPath();
        Tree parent = parentPath.getLeaf();
        if (!(parent instanceof IfTree)) {
            return Description.NO_MATCH;
        }
        IfTree ifTree = (IfTree)parent;
        if (!(ifTree.getThenStatement() instanceof EmptyStatementTree) || ifTree.getElseStatement() != null) {
            return Description.NO_MATCH;
        }
        if (Matchers.isLastStatementInBlock().matches(ifTree, state.withPath(parentPath))) {
            return this.describeMatch(parent, (Fix)SuggestedFix.delete(parent));
        }
        return this.describeMatch(ifTree.getThenStatement(), (Fix)SuggestedFix.delete(ifTree.getThenStatement()));
    }
}

