/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;

@BugPattern(summary="Empty top-level type declarations should be omitted", severity=BugPattern.SeverityLevel.ERROR)
public final class EmptyTopLevelDeclaration
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        ImmutableList<Tree> toDelete = tree.getTypeDecls().stream().filter(m -> m.getKind() == Tree.Kind.EMPTY_STATEMENT).collect(ImmutableList.toImmutableList());
        if (toDelete.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        toDelete.forEach(fixBuilder::delete);
        return this.describeMatch((Tree)toDelete.get(0), (Fix)fixBuilder.build());
    }
}

