/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Prefer instanceof to getClass when implementing Object#equals.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class EqualsGetClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> GET_CLASS = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").named("getClass");

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!GET_CLASS.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        TreePath methodTreePath = state.findPathToEnclosing(MethodTree.class);
        if (methodTreePath == null) {
            return Description.NO_MATCH;
        }
        ClassTree classTree = (ClassTree)state.findEnclosing(ClassTree.class);
        if (classTree == null || classTree.getModifiers().getFlags().contains((Object)Modifier.FINAL)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol classSymbol = ASTHelpers.getSymbol(classTree);
        if (classSymbol.isAnonymous()) {
            return Description.NO_MATCH;
        }
        MethodTree methodTree = (MethodTree)methodTreePath.getLeaf();
        if (!Matchers.equalsMethodDeclaration().matches(methodTree, state)) {
            return Description.NO_MATCH;
        }
        VariableTree parameter = Iterables.getOnlyElement(methodTree.getParameters());
        ExpressionTree receiver = ASTHelpers.getReceiver(tree);
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol(parameter);
        if (receiver == null || receiver.getKind() != Tree.Kind.IDENTIFIER || !symbol.equals(ASTHelpers.getSymbol(receiver))) {
            return Description.NO_MATCH;
        }
        EqualsFixer fixer = new EqualsFixer(symbol, ASTHelpers.getSymbol(classTree), state);
        fixer.scan(methodTreePath, null);
        return this.describeMatch(methodTree, (Fix)fixer.getFix());
    }

    private static class EqualsFixer
    extends TreePathScanner<Void, Void> {
        private static final Matcher<ExpressionTree> GET_CLASS = MethodMatchers.instanceMethod().onDescendantOf("java.lang.Object").named("getClass").withNoParameters();
        private static final Matcher<ExpressionTree> THIS_CLASS = Matchers.anyOf(Matchers.allOf(GET_CLASS, (tree, unused) -> EqualsFixer.matchesThis(tree)), (tree, unused) -> EqualsFixer.matchesClass(tree));
        private final Symbol parameter;
        private final Symbol.ClassSymbol classSymbol;
        private final VisitorState state;
        private final SuggestedFix.Builder fix = SuggestedFix.builder();
        private final Matcher<ExpressionTree> isParameter;
        private final Matcher<ExpressionTree> otherClass;
        private boolean matchedGetClass = false;
        private boolean failed = false;

        private static boolean matchesThis(ExpressionTree tree) {
            ExpressionTree receiver = ASTHelpers.getReceiver(tree);
            if (receiver == null) {
                return true;
            }
            while (!(receiver instanceof IdentifierTree)) {
                if (receiver instanceof ParenthesizedTree) {
                    receiver = ((ParenthesizedTree)receiver).getExpression();
                    continue;
                }
                if (receiver instanceof TypeCastTree) {
                    receiver = ((TypeCastTree)receiver).getExpression();
                    continue;
                }
                return false;
            }
            Symbol symbol = ASTHelpers.getSymbol(receiver);
            return symbol != null && symbol.getSimpleName().contentEquals("this");
        }

        private static boolean matchesClass(ExpressionTree tree) {
            Symbol symbol = ASTHelpers.getSymbol(tree);
            if (!(symbol instanceof Symbol.VarSymbol)) {
                return false;
            }
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            return ((Name)varSymbol.getSimpleName()).contentEquals("class");
        }

        private EqualsFixer(Symbol parameter, Symbol.ClassSymbol classSymbol, VisitorState visitorState) {
            this.parameter = parameter;
            this.classSymbol = classSymbol;
            this.state = visitorState;
            this.isParameter = (tree, state) -> parameter.equals(ASTHelpers.getSymbol(tree));
            this.otherClass = Matchers.allOf(GET_CLASS, (tree, state) -> parameter.equals(ASTHelpers.getSymbol(ASTHelpers.getReceiver(tree))));
        }

        @Override
        public Void visitBinary(BinaryTree binaryTree, Void unused) {
            if (binaryTree.getKind() != Tree.Kind.NOT_EQUAL_TO && binaryTree.getKind() != Tree.Kind.EQUAL_TO) {
                return (Void)super.visitBinary(binaryTree, null);
            }
            if (this.matchesEitherWay(binaryTree, this.isParameter, Matchers.nullLiteral())) {
                if (binaryTree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                    this.makeAlwaysTrue();
                }
                if (binaryTree.getKind() == Tree.Kind.EQUAL_TO) {
                    this.makeAlwaysFalse();
                }
                return null;
            }
            if (this.matchesEitherWay(binaryTree, THIS_CLASS, this.otherClass)) {
                this.matchedGetClass = true;
                String instanceOf = String.format("%s instanceof %s", this.parameter.getSimpleName(), this.classSymbol.getSimpleName());
                if (binaryTree.getKind() == Tree.Kind.EQUAL_TO) {
                    this.fix.replace(binaryTree, instanceOf);
                }
                if (binaryTree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
                    this.fix.replace(binaryTree, String.format("!(%s)", instanceOf));
                }
            }
            return (Void)super.visitBinary(binaryTree, null);
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
            if (!Matchers.instanceEqualsInvocation().matches(node, this.state)) {
                return null;
            }
            ExpressionTree argument = Iterables.getOnlyElement(node.getArguments());
            ExpressionTree receiver = ASTHelpers.getReceiver(node);
            if (receiver == null) {
                return null;
            }
            if (this.matchesEitherWay(argument, receiver, THIS_CLASS, this.otherClass)) {
                this.matchedGetClass = true;
                String replacement = String.format("%s instanceof %s", this.parameter.getSimpleName(), this.classSymbol.getSimpleName());
                if (this.getCurrentPath().getParentPath().getLeaf() instanceof UnaryTree) {
                    replacement = String.format("(%s)", replacement);
                }
                this.fix.replace(node, replacement);
            }
            return (Void)super.visitMethodInvocation(node, null);
        }

        private boolean matchesEitherWay(BinaryTree binaryTree, Matcher<ExpressionTree> matcherA, Matcher<ExpressionTree> matcherB) {
            return this.matchesEitherWay(binaryTree.getLeftOperand(), binaryTree.getRightOperand(), matcherA, matcherB);
        }

        private boolean matchesEitherWay(ExpressionTree treeA, ExpressionTree treeB, Matcher<ExpressionTree> matcherA, Matcher<ExpressionTree> matcherB) {
            return matcherA.matches(treeA, this.state) && matcherB.matches(treeB, this.state) || matcherA.matches(treeB, this.state) && matcherB.matches(treeA, this.state);
        }

        private void makeAlwaysTrue() {
            this.removeFromBinary(Tree.Kind.CONDITIONAL_AND);
        }

        private void makeAlwaysFalse() {
            TreePath enclosingPath = this.getCurrentPath().getParentPath();
            while (enclosingPath.getLeaf() instanceof ParenthesizedTree) {
                enclosingPath = enclosingPath.getParentPath();
            }
            Tree enclosing = enclosingPath.getLeaf();
            if (enclosing instanceof IfTree) {
                IfTree ifTree = (IfTree)enclosing;
                if (ifTree.getElseStatement() == null) {
                    this.fix.replace(ifTree, "");
                } else {
                    int stripExtra = ifTree.getElseStatement() instanceof BlockTree ? 1 : 0;
                    this.fix.replace(ASTHelpers.getStartPosition(ifTree), ASTHelpers.getStartPosition(ifTree.getElseStatement()) + stripExtra, "").replace(this.state.getEndPosition(ifTree.getElseStatement()) - stripExtra, this.state.getEndPosition(ifTree.getElseStatement()), "");
                }
                return;
            }
            this.removeFromBinary(Tree.Kind.CONDITIONAL_OR);
        }

        private void removeFromBinary(Tree.Kind ifKind) {
            TreePath outsideParensPath = this.getCurrentPath().getParentPath();
            TreePath justInsideBinaryPath = this.getCurrentPath();
            while (outsideParensPath.getLeaf() instanceof ParenthesizedTree) {
                justInsideBinaryPath = outsideParensPath;
                outsideParensPath = outsideParensPath.getParentPath();
            }
            Tree superTree = outsideParensPath.getLeaf();
            if (superTree.getKind() != ifKind) {
                this.failed = true;
                return;
            }
            BinaryTree superBinary = (BinaryTree)superTree;
            if (superBinary.getLeftOperand().equals(justInsideBinaryPath.getLeaf())) {
                this.removeLeftOperand(superBinary);
            } else {
                this.removeRightOperand(superBinary);
            }
        }

        private void removeLeftOperand(BinaryTree superBinary) {
            this.fix.replace(ASTHelpers.getStartPosition(superBinary.getLeftOperand()), ASTHelpers.getStartPosition(superBinary.getRightOperand()), "");
        }

        private void removeRightOperand(BinaryTree superBinary) {
            this.fix.replace(this.state.getEndPosition(superBinary.getLeftOperand()), this.state.getEndPosition(superBinary.getRightOperand()), "");
        }

        private SuggestedFix getFix() {
            return this.matchedGetClass && !this.failed ? this.fix.build() : SuggestedFix.emptyFix();
        }
    }
}

