/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.util.TreeScanner;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(summary="Implementing #equals by just comparing hashCodes is fragile. Hashes collide frequently, and this will lead to false positives in #equals.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public final class EqualsUsingHashCode
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = Matchers.allOf(MethodMatchers.instanceMethod().anyClass().named("hashCode"), Matchers.enclosingMethod(Matchers.equalsMethodDeclaration()));

    @Override
    public Description matchMethodInvocation(final MethodInvocationTree tree, VisitorState state) {
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ReturnTree returnTree = (ReturnTree)state.findEnclosing(ReturnTree.class);
        if (returnTree == null) {
            return Description.NO_MATCH;
        }
        final AtomicBoolean isTerminalCondition = new AtomicBoolean(false);
        returnTree.accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree methodTree, Void unused) {
                if (methodTree.equals(tree)) {
                    isTerminalCondition.set(true);
                }
                return (Void)super.visitMethodInvocation(methodTree, null);
            }

            @Override
            public Void visitBinary(BinaryTree binaryTree, Void unused) {
                return (Void)this.scan(binaryTree.getRightOperand(), null);
            }
        }, null);
        return isTerminalCondition.get() ? this.describeMatch(tree) : Description.NO_MATCH;
    }
}

