/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Futures.getChecked requires a checked exception type with a standard constructor.", severity=BugPattern.SeverityLevel.ERROR)
public final class FuturesGetCheckedIllegalExceptionType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> FUTURES_GET_CHECKED_MATCHER = Matchers.anyOf(MethodMatchers.staticMethod().onClass(Futures.class.getName()).named("getChecked"));
    private static final Matcher<ExpressionTree> CLASS_OBJECT_FOR_CLASS_EXTENDING_RUNTIME_EXCEPTION = new Matcher<ExpressionTree>(){

        @Override
        public boolean matches(ExpressionTree tree, VisitorState state) {
            Types types = state.getTypes();
            Type classType = state.getSymtab().classType;
            Type runtimeExceptionType = state.getSymtab().runtimeExceptionType;
            Type argType = ASTHelpers.getType(tree);
            if (!ASTHelpers.isSubtype(argType, classType, state) || argType.getTag() == TypeTag.BOT) {
                return false;
            }
            List<Type> typeArguments = argType.getTypeArguments();
            Type exceptionType = Iterables.getFirst(typeArguments, null);
            return types.isSubtype(exceptionType, runtimeExceptionType);
        }
    };
    private static final Matcher<MethodInvocationTree> PASSED_RUNTIME_EXCEPTION_TYPE = Matchers.argument(1, CLASS_OBJECT_FOR_CLASS_EXTENDING_RUNTIME_EXCEPTION);
    private static final Matcher<ExpressionTree> CLASS_OBJECT_FOR_CLASS_WITHOUT_USABLE_CONSTRUCTOR = Matchers.classLiteral((Matcher<? super ExpressionTree>)new Matcher<ExpressionTree>(){

        @Override
        public boolean matches(ExpressionTree tree, VisitorState state) {
            Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)ASTHelpers.getSymbol(tree);
            if (classSymbol == null) {
                return false;
            }
            if (classSymbol.isInner()) {
                return true;
            }
            for (Symbol enclosedSymbol : classSymbol.getEnclosedElements()) {
                Symbol.MethodSymbol constructorSymbol;
                if (!enclosedSymbol.isConstructor() || !FuturesGetCheckedIllegalExceptionType.canBeUsedByGetChecked(constructorSymbol = (Symbol.MethodSymbol)enclosedSymbol, state)) continue;
                return false;
            }
            return true;
        }
    });
    private static final Matcher<MethodInvocationTree> PASSED_TYPE_WITHOUT_USABLE_CONSTRUCTOR = Matchers.argument(1, CLASS_OBJECT_FOR_CLASS_WITHOUT_USABLE_CONSTRUCTOR);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!FUTURES_GET_CHECKED_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (PASSED_RUNTIME_EXCEPTION_TYPE.matches(tree, state)) {
            return this.describeUncheckedExceptionTypeMatch(tree, SuggestedFix.builder().replace(tree, "getUnchecked(" + state.getSourceForNode(tree.getArguments().get(0)) + ")").addStaticImport(Futures.class.getName() + ".getUnchecked").build());
        }
        if (PASSED_TYPE_WITHOUT_USABLE_CONSTRUCTOR.matches(tree, state)) {
            return this.describeNoValidConstructorMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static boolean canBeUsedByGetChecked(Symbol.MethodSymbol constructor, VisitorState state) {
        Type stringType = state.getSymtab().stringType;
        Type throwableType = state.getSymtab().throwableType;
        if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return false;
        }
        for (Symbol.VarSymbol param : constructor.getParameters()) {
            if (ASTHelpers.isSameType((Type)param.asType(), stringType, state) || ASTHelpers.isSameType((Type)param.asType(), throwableType, state)) continue;
            return false;
        }
        return true;
    }

    private Description describeUncheckedExceptionTypeMatch(Tree tree, Fix fix) {
        return this.buildDescription(tree).setMessage("The exception class passed to getChecked must be a checked exception, not a RuntimeException.").addFix(fix).build();
    }

    private Description describeNoValidConstructorMatch(Tree tree) {
        return this.buildDescription(tree).setMessage("The exception class passed to getChecked must declare a public constructor whose only parameters are of type String or Throwable.").build();
    }
}

