/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="DoubleMath.fuzzyEquals should never be used in an Object.equals() method", severity=BugPattern.SeverityLevel.ERROR)
public class FuzzyEqualsShouldNotBeUsedInEqualsMethod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> CALL_TO_FUZZY_IN_EQUALS = Matchers.allOf(Matchers.staticMethod().onClass("com.google.common.math.DoubleMath").named("fuzzyEquals"), Matchers.enclosingMethod(Matchers.equalsMethodDeclaration()));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (CALL_TO_FUZZY_IN_EQUALS.matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

