/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Calling getClass() on an enum may return a subclass of the enum type", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class GetClassOnEnum
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ENUM_CLASS = MethodMatchers.instanceMethod().onDescendantOf(Enum.class.getName()).named("getClass").withNoParameters();

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (ENUM_CLASS.matches(tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace(state.getEndPosition(ASTHelpers.getReceiver(tree)), state.getEndPosition(tree), ".getDeclaringClass()"));
        }
        return Description.NO_MATCH;
    }
}

