/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

@BugPattern(severity=BugPattern.SeverityLevel.ERROR, summary="Getters on AutoValues, AutoBuilders, and Protobuf Messages are side-effect free, so there is no point in calling them if the return value is ignored. While there are no side effects from the getter, the receiver may have side effects.")
public final class IgnoredPureGetter
extends AbstractReturnValueIgnored {
    private static final Supplier<Type> MESSAGE_LITE = VisitorState.memoize(state -> state.getTypeFromString("com.google.protobuf.MessageLite"));
    private static final Supplier<Type> MUTABLE_MESSAGE_LITE = VisitorState.memoize(state -> state.getTypeFromString("com.google.protobuf.MutableMessageLite"));

    public IgnoredPureGetter() {
        this(ErrorProneFlags.empty());
    }

    public IgnoredPureGetter(ErrorProneFlags flags) {
        super(flags);
    }

    @Override
    protected Matcher<? super ExpressionTree> specializedMatcher() {
        return IgnoredPureGetter::isPureGetter;
    }

    @Override
    public ImmutableMap<String, ?> getMatchMetadata(ExpressionTree tree, VisitorState state) {
        return IgnoredPureGetter.pureGetterKind(tree, state).map(kind -> ImmutableMap.of("pure_getter_kind", kind)).orElse(ImmutableMap.of());
    }

    @Override
    protected Description describeReturnValueIgnored(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        Description.Builder builder = this.buildDescription(methodInvocationTree).addFix(SuggestedFix.builder().setShortDescription("Remove with any side effects from the receiver").delete(parent instanceof ExpressionStatementTree ? parent : methodInvocationTree).build());
        ExpressionTree receiver = ASTHelpers.getReceiver(methodInvocationTree);
        if (receiver instanceof MethodInvocationTree) {
            builder.addFix(SuggestedFix.builder().setShortDescription("Remove but keep side effects from the receiver").replace(methodInvocationTree, state.getSourceForNode(receiver)).build());
        }
        return builder.build();
    }

    private static boolean isPureGetter(ExpressionTree tree, VisitorState state) {
        return IgnoredPureGetter.pureGetterKind(tree, state).isPresent();
    }

    private static Optional<PureGetterKind> pureGetterKind(ExpressionTree tree, VisitorState state) {
        Symbol rawSymbol = ASTHelpers.getSymbol(tree);
        if (!(rawSymbol instanceof Symbol.MethodSymbol)) {
            return Optional.empty();
        }
        Symbol.MethodSymbol symbol = (Symbol.MethodSymbol)rawSymbol;
        Symbol owner = symbol.owner;
        if (symbol.getModifiers().contains((Object)Modifier.ABSTRACT) && ((List)symbol.getParameters()).isEmpty()) {
            if (ASTHelpers.hasAnnotation(owner, "com.google.auto.value.AutoValue", state)) {
                return Optional.of(PureGetterKind.AUTO_VALUE);
            }
            if (ASTHelpers.hasAnnotation(owner, "com.google.auto.value.AutoBuilder", state) && !ASTHelpers.isSameType(symbol.getReturnType(), owner.type, state)) {
                return Optional.of(PureGetterKind.AUTO_BUILDER);
            }
            if (ASTHelpers.hasAnnotation(owner, "com.google.auto.value.AutoValue.Builder", state) && !ASTHelpers.isSameType(symbol.getReturnType(), owner.type, state)) {
                return Optional.of(PureGetterKind.AUTO_VALUE_BUILDER);
            }
        }
        try {
            if (ASTHelpers.isSubtype(owner.type, MESSAGE_LITE.get(state), state) && !ASTHelpers.isSubtype(owner.type, MUTABLE_MESSAGE_LITE.get(state), state)) {
                return Optional.of(PureGetterKind.PROTO);
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            // empty catch block
        }
        return Optional.empty();
    }

    private static enum PureGetterKind {
        AUTO_VALUE,
        AUTO_VALUE_BUILDER,
        AUTO_BUILDER,
        PROTO;

    }
}

