/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

@BugPattern(summary="This private static ImmutableList is only used for contains, containsAll or isEmpty checks; prefer ImmutableSet.", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class ImmutableSetForContains
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<Tree> PRIVATE_STATIC_IMMUTABLE_LIST_MATCHER = Matchers.allOf(Matchers.isStatic(), Matchers.hasModifier(Modifier.PRIVATE), Matchers.hasModifier(Modifier.FINAL), Matchers.isSameType(ImmutableList.class));
    private static final Matcher<Tree> EXCLUSIONS = Matchers.anyOf((t, s) -> ASTHelpers.shouldKeep(t), Matchers.hasAnnotationWithSimpleName("Bind"), Matchers.hasAnnotationWithSimpleName("Inject"));
    private static final Matcher<ExpressionTree> IMMUTABLE_LIST_FACTORIES = Matchers.staticMethod().onClass(ImmutableList.class.getName()).namedAnyOf("of", "copyOf");
    private static final Matcher<ExpressionTree> IMMUTABLE_LIST_BUILD = Matchers.instanceMethod().onExactClass(ImmutableList.Builder.class.getName()).namedAnyOf("build");
    private static final Matcher<ExpressionTree> IMMUTABLE_COLLECTION = Matchers.instanceMethod().onExactClass(Stream.class.getName()).named("collect");
    private static final Matcher<ExpressionTree> IMMUTABLE_BUILDER_METHODS = Matchers.instanceMethod().onExactClass(ImmutableList.Builder.class.getName()).namedAnyOf("add", "addAll");

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableSet<VariableTree> immutableListVar = tree.getMembers().stream().filter(member -> member.getKind().equals((Object)Tree.Kind.VARIABLE)).map(VariableTree.class::cast).filter(member -> PRIVATE_STATIC_IMMUTABLE_LIST_MATCHER.matches((Tree)member, state) && !EXCLUSIONS.matches((Tree)member, state)).collect(ImmutableSet.toImmutableSet());
        if (immutableListVar.isEmpty()) {
            return Description.NO_MATCH;
        }
        ImmutableVarUsageScanner usageScanner = new ImmutableVarUsageScanner(immutableListVar);
        TreePath cuPath = state.findPathToEnclosing(CompilationUnitTree.class);
        usageScanner.scan(cuPath.getLeaf(), state.withPath(cuPath));
        SuggestedFix.Builder fix = SuggestedFix.builder();
        Optional<Object> firstReplacement = Optional.empty();
        for (VariableTree var : immutableListVar) {
            if (this.isSuppressed(var, state) || usageScanner.disallowedVarUsages.get(ASTHelpers.getSymbol(var)).booleanValue()) continue;
            firstReplacement = Optional.of(var);
            fix.merge(ImmutableSetForContains.convertListToSetInit(var, state));
        }
        if (!firstReplacement.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch((Tree)firstReplacement.get(), (Fix)fix.build());
    }

    private static SuggestedFix convertListToSetInit(VariableTree var, VisitorState state) {
        Optional<ExpressionTree> rootExpr;
        SuggestedFix.Builder fix = SuggestedFix.builder().addImport(ImmutableSet.class.getName()).replace(ImmutableSetForContains.stripParameters(var.getType()), "ImmutableSet");
        if (IMMUTABLE_LIST_FACTORIES.matches(var.getInitializer(), state)) {
            fix.replace(ASTHelpers.getReceiver(var.getInitializer()), "ImmutableSet");
            return fix.build();
        }
        if (IMMUTABLE_COLLECTION.matches(var.getInitializer(), state)) {
            fix.addStaticImport("com.google.common.collect.ImmutableSet.toImmutableSet").replace(Iterables.getOnlyElement(((MethodInvocationTree)var.getInitializer()).getArguments()), "toImmutableSet()");
            return fix.build();
        }
        if (IMMUTABLE_LIST_BUILD.matches(var.getInitializer(), state) && (rootExpr = ImmutableSetForContains.getRootMethod((MethodInvocationTree)var.getInitializer(), state)).isPresent()) {
            if (rootExpr.get().getKind().equals((Object)Tree.Kind.METHOD_INVOCATION)) {
                MethodInvocationTree methodTree = (MethodInvocationTree)rootExpr.get();
                fix.replace(ASTHelpers.getReceiver(methodTree), "ImmutableSet");
                return fix.build();
            }
            if (rootExpr.get().getKind().equals((Object)Tree.Kind.NEW_CLASS)) {
                NewClassTree ctorTree = (NewClassTree)rootExpr.get();
                fix.replace(ImmutableSetForContains.stripParameters(ctorTree.getIdentifier()), "ImmutableSet.Builder");
            }
            return fix.build();
        }
        return fix.replace(var.getInitializer(), "ImmutableSet.copyOf(" + state.getSourceForNode(var.getInitializer()) + ")").build();
    }

    private static Tree stripParameters(Tree tree) {
        return tree.getKind().equals((Object)Tree.Kind.PARAMETERIZED_TYPE) ? ((ParameterizedTypeTree)tree).getType() : tree;
    }

    private static Optional<ExpressionTree> getRootMethod(MethodInvocationTree methodInvocationTree, VisitorState state) {
        return ASTHelpers.streamReceivers(methodInvocationTree).filter(t -> !IMMUTABLE_BUILDER_METHODS.matches((ExpressionTree)t, state)).findFirst();
    }

    private static final class ImmutableVarUsageScanner
    extends TreeScanner<Void, VisitorState> {
        private static final Matcher<ExpressionTree> ALLOWED_FUNCTIONS_ON_LIST = Matchers.instanceMethod().onExactClass(ImmutableList.class.getName()).namedAnyOf("contains", "containsAll", "isEmpty");
        private final Map<Symbol, Boolean> disallowedVarUsages;

        private ImmutableVarUsageScanner(ImmutableSet<VariableTree> immutableListVar) {
            this.disallowedVarUsages = immutableListVar.stream().map(ASTHelpers::getSymbol).collect(Collectors.toMap(x -> x, x -> Boolean.FALSE));
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
            methodInvocationTree.getArguments().forEach(tree -> this.scan((Tree)tree, state));
            methodInvocationTree.getTypeArguments().forEach(tree -> this.scan((Tree)tree, state));
            if (!this.allowedFuncOnImmutableVar(methodInvocationTree, state)) {
                this.scan(methodInvocationTree.getMethodSelect(), state);
            }
            return null;
        }

        private boolean allowedFuncOnImmutableVar(MethodInvocationTree methodTree, VisitorState state) {
            ExpressionTree receiver = ASTHelpers.getReceiver(methodTree);
            if (receiver == null) {
                return false;
            }
            if (!this.disallowedVarUsages.containsKey(ASTHelpers.getSymbol(receiver))) {
                return false;
            }
            return ALLOWED_FUNCTIONS_ON_LIST.matches(methodTree, state);
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, VisitorState visitorState) {
            this.recordDisallowedUsage(ASTHelpers.getSymbol(identifierTree));
            return (Void)super.visitIdentifier(identifierTree, visitorState);
        }

        @Override
        public Void visitMemberSelect(MemberSelectTree memberSelectTree, VisitorState visitorState) {
            this.recordDisallowedUsage(ASTHelpers.getSymbol(memberSelectTree));
            return (Void)super.visitMemberSelect(memberSelectTree, visitorState);
        }

        private void recordDisallowedUsage(Symbol symbol) {
            this.disallowedVarUsages.computeIfPresent(symbol, (sym, oldVal) -> Boolean.TRUE);
        }
    }
}

