/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;

@BugPattern(summary="Conditional expression in varargs call contains array and non-array arguments", severity=BugPattern.SeverityLevel.ERROR)
public class InexactVarargsConditional
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (!sym.isVarArgs()) {
            return Description.NO_MATCH;
        }
        if (tree.getArguments().size() != ((List)sym.getParameters()).size()) {
            return Description.NO_MATCH;
        }
        Tree arg = Iterables.getLast(tree.getArguments());
        if (!(arg instanceof ConditionalExpressionTree)) {
            return Description.NO_MATCH;
        }
        Types types = state.getTypes();
        if (types.isArray(ASTHelpers.getType(arg))) {
            return Description.NO_MATCH;
        }
        ConditionalExpressionTree cond = (ConditionalExpressionTree)arg;
        boolean trueIsArray = types.isArray(ASTHelpers.getType(cond.getTrueExpression()));
        if (!(trueIsArray ^ types.isArray(ASTHelpers.getType(cond.getFalseExpression())))) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String qualified = SuggestedFixes.qualifyType(state, fix, types.elemtype((Type)((Symbol.VarSymbol)Iterables.getLast(sym.getParameters())).asType()));
        ExpressionTree toFix = !trueIsArray ? cond.getTrueExpression() : cond.getFalseExpression();
        fix.prefixWith(toFix, String.format("new %s[] {", qualified)).postfixWith(toFix, "}");
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

