/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_IsInstanceOfClass_Operand;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="The argument to Class#isInstance(Object) should not be a Class", severity=BugPattern.SeverityLevel.ERROR)
public class IsInstanceOfClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> INSTANCE_OF_CLASS = Matchers.allOf(Matchers.instanceMethod().onExactClass("java.lang.Class").named("isInstance"), Matchers.argument(0, Matchers.isSubtypeOf("java.lang.Class")));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!INSTANCE_OF_CLASS.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, IsInstanceOfClass.buildReplacement(tree, state)));
    }

    static String buildReplacement(MethodInvocationTree tree, VisitorState state) {
        Operand lhs = IsInstanceOfClass.classify((JCTree)((Object)ASTHelpers.getReceiver(tree.getMethodSelect())), state);
        Operand rhs = IsInstanceOfClass.classify((JCTree)((Object)Iterables.getOnlyElement(tree.getArguments())), state);
        if (lhs.kind() == Kind.GET_CLASS && rhs.kind() == Kind.LITERAL) {
            return String.format("%s instanceof %s", lhs.value(), rhs.value());
        }
        if (lhs.kind() == Kind.GET_CLASS && rhs.kind() == Kind.GET_CLASS) {
            return String.format("%s.getClass().isInstance(%s)", rhs.value(), lhs.value());
        }
        if (lhs.kind() == Kind.LITERAL && rhs.kind() == Kind.LITERAL) {
            return String.format("%s.class == Class.class", rhs.value());
        }
        if (lhs.kind() == Kind.LITERAL && rhs.kind() == Kind.GET_CLASS) {
            return String.format("%s instanceof %s", rhs.value(), lhs.value());
        }
        if (rhs.kind() == Kind.GET_CLASS) {
            return String.format("%s.isInstance(%s)", lhs.source(), rhs.value());
        }
        if (lhs.kind() == Kind.GET_CLASS) {
            return String.format("%s.isInstance(%s)", rhs.source(), lhs.value());
        }
        return String.format("%s.isAssignableFrom(%s)", rhs.source(), lhs.source());
    }

    static Operand classify(JCTree tree, VisitorState state) {
        MemberSelectTree select;
        String source = state.getSourceForNode(tree);
        if (tree instanceof MethodInvocationTree) {
            MethodInvocationTree receiverInvocation = (MethodInvocationTree)((Object)tree);
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol(receiverInvocation);
            if (((Name)sym.getSimpleName()).contentEquals("getClass") && sym.params().isEmpty()) {
                if (receiverInvocation.getMethodSelect() instanceof IdentifierTree) {
                    return Operand.create(Kind.EXPR, state.getSourceForNode(tree), source);
                }
                return Operand.create(Kind.GET_CLASS, state.getSourceForNode(ASTHelpers.getReceiver(receiverInvocation)), source);
            }
        } else if (tree instanceof MemberSelectTree && (select = (MemberSelectTree)((Object)tree)).getIdentifier().contentEquals("class")) {
            return Operand.create(Kind.LITERAL, state.getSourceForNode(select.getExpression()), source);
        }
        return Operand.create(Kind.EXPR, source, source);
    }

    @AutoValue
    static abstract class Operand {
        Operand() {
        }

        abstract Kind kind();

        abstract CharSequence value();

        abstract CharSequence source();

        static Operand create(Kind kind, CharSequence value, CharSequence source) {
            return new AutoValue_IsInstanceOfClass_Operand(kind, value, source);
        }
    }

    static enum Kind {
        LITERAL,
        GET_CLASS,
        EXPR;

    }
}

