/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.tree.JCTree;
import java.nio.file.Path;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="Path implements Iterable<Path>; prefer Collection<Path> for clarity", severity=BugPattern.SeverityLevel.ERROR)
public class IterablePathParameter
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Type type = ASTHelpers.getType(tree);
        Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
        if (type == null) {
            return Description.NO_MATCH;
        }
        if (symbol.getKind() != ElementKind.PARAMETER) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType(type, state.getSymtab().iterableType, state)) {
            return Description.NO_MATCH;
        }
        if (type.getTypeArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType(IterablePathParameter.wildBound(Iterables.getOnlyElement(type.getTypeArguments())), state.getTypeFromString(Path.class.getName()), state)) {
            return Description.NO_MATCH;
        }
        Description.Builder description = this.buildDescription(tree);
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (tree.getType() instanceof ParameterizedTypeTree && (!(parent instanceof JCTree.JCLambda) || ((JCTree.JCLambda)parent).paramKind == JCTree.JCLambda.ParameterKind.EXPLICIT)) {
            description.addFix(SuggestedFix.builder().addImport("java.util.Collection").replace(((ParameterizedTypeTree)tree.getType()).getType(), "Collection").build());
        }
        return description.build();
    }

    static Type wildBound(Type type) {
        return type.hasTag(TypeTag.WILDCARD) ? ((Type.WildcardType)type).type : type;
    }
}

