/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;

@BugPattern(summary="Test method will not be run; please correct method signature (Should be public, non-static, and method name should begin with \"test\").", severity=BugPattern.SeverityLevel.ERROR)
public final class JUnit3TestNotRun
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Pattern MISSPELLED_NAME = Pattern.compile("t.est|te.st|tst|tet|tes|etst|tset|tets|t.st|te.t|[tT][eE][sS][tT]");
    private static final com.google.errorprone.matchers.Matcher<MethodTree> LOOKS_LIKE_TEST_CASE = Matchers.allOf(Matchers.enclosingClass(JUnitMatchers.isJUnit3TestClass), Matchers.not(JUnitMatchers.isJunit3TestCase), Matchers.anyOf(Matchers.methodHasNoParameters(), Matchers.hasModifier(Modifier.PUBLIC)), Matchers.enclosingClass((t, s) -> !ASTHelpers.getSymbol(t).getSimpleName().toString().endsWith("Base")), Matchers.methodReturns(Suppliers.VOID_TYPE));

    @Override
    public Description matchCompilationUnit(CompilationUnitTree unused, final VisitorState state) {
        final ImmutableSet<Symbol.MethodSymbol> calledMethods = JUnit3TestNotRun.calledMethods(state);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitMethod(MethodTree tree, Void unused) {
                JUnit3TestNotRun.this.checkMethod(tree, calledMethods, state.withPath(this.getCurrentPath())).ifPresent(state::reportMatch);
                return (Void)super.visitMethod(tree, null);
            }
        }.scan(state.getPath(), null);
        return Description.NO_MATCH;
    }

    private static ImmutableSet<Symbol.MethodSymbol> calledMethods(VisitorState state) {
        final ImmutableSet.Builder calledMethods = ImmutableSet.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                calledMethods.add(ASTHelpers.getSymbol(tree));
                return (Void)super.visitMethodInvocation(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return calledMethods.build();
    }

    public Optional<Description> checkMethod(MethodTree methodTree, ImmutableSet<Symbol.MethodSymbol> calledMethods, VisitorState state) {
        if (calledMethods.contains(ASTHelpers.getSymbol(methodTree))) {
            return Optional.empty();
        }
        if (!LOOKS_LIKE_TEST_CASE.matches(methodTree, state)) {
            return Optional.empty();
        }
        if (!ASTHelpers.findSuperMethods(ASTHelpers.getSymbol(methodTree), state.getTypes()).isEmpty()) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String methodName = methodTree.getName().toString();
        if (!methodName.startsWith("test")) {
            Object fixedName;
            Matcher matcher = MISSPELLED_NAME.matcher(methodName);
            if (matcher.lookingAt()) {
                fixedName = matcher.replaceFirst("test");
            } else if (JUnitMatchers.wouldRunInJUnit4.matches(methodTree, state)) {
                fixedName = "test" + Ascii.toUpperCase(methodName.substring(0, 1)) + methodName.substring(1);
            } else {
                return Optional.empty();
            }
            fix.merge(SuggestedFixes.renameMethod(methodTree, (String)fixedName, state));
        }
        SuggestedFixes.addModifiers((Tree)methodTree, state, Modifier.PUBLIC).ifPresent(fix::merge);
        SuggestedFixes.removeModifiers(methodTree, state, Modifier.PRIVATE, Modifier.PROTECTED).ifPresent(fix::merge);
        SuggestedFixes.removeModifiers(methodTree, state, Modifier.STATIC).ifPresent(fix::merge);
        return Optional.of(this.describeMatch(methodTree, (Fix)fix.build()));
    }
}

