/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@BugPattern(summary="This method should be static", severity=BugPattern.SeverityLevel.ERROR)
public class JUnit4ClassAnnotationNonStatic
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> CLASS_INIT_ANNOTATION = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.isType("org.junit.AfterClass"), Matchers.isType("org.junit.BeforeClass")));

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        MultiMatcher.MultiMatchResult<AnnotationTree> matchResult = CLASS_INIT_ANNOTATION.multiMatchResult(tree, state);
        if (!matchResult.matches() || Matchers.isStatic().matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(JUnit4ClassAnnotationNonStatic.messageForAnnos(matchResult.matchingNodes())).addFix(SuggestedFixes.addModifiers((Tree)tree, state, Modifier.STATIC).orElse(SuggestedFix.emptyFix())).build();
    }

    private static String messageForAnnos(List<AnnotationTree> annotationTrees) {
        String annoNames = annotationTrees.stream().map(a -> Signatures.prettyType(ASTHelpers.getType(a))).collect(Collectors.joining(" and "));
        return annoNames + " can only be applied to static methods.";
    }
}

