/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Type;

@BugPattern(summary="This test is annotated @Test, but given it's within a class using the Enclosed runner, will not run.", severity=BugPattern.SeverityLevel.ERROR)
public final class JUnit4TestsNotRunWithinEnclosed
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final MultiMatcher<ClassTree, AnnotationTree> ENCLOSED = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.allOf(Matchers.isType("org.junit.runner.RunWith"), Matchers.hasArgumentWithValue("value", JUnitMatchers.isJUnit4TestRunnerOfType(ImmutableSet.of("org.junit.experimental.runners.Enclosed")))));

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        final ImmutableSet<Type> extendedTypes = JUnit4TestsNotRunWithinEnclosed.getExtendedTypes(state);
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (!ENCLOSED.matches(classTree, state)) {
                    return (Void)super.visitClass(classTree, null);
                }
                Type.ClassType classType = ASTHelpers.getType(classTree);
                if (extendedTypes.stream().anyMatch(t -> ASTHelpers.isSameType(t, classType, state))) {
                    return (Void)super.visitClass(classTree, null);
                }
                for (Tree tree : classTree.getMembers()) {
                    if (!(tree instanceof MethodTree) || !JUnitMatchers.TEST_CASE.matches((MethodTree)tree, state)) continue;
                    SuggestedFix.Builder fix = SuggestedFix.builder();
                    String junit4 = SuggestedFixes.qualifyType(state, fix, "org.junit.runners.JUnit4");
                    state.reportMatch(JUnit4TestsNotRunWithinEnclosed.this.describeMatch(tree, (Fix)fix.merge(SuggestedFixes.updateAnnotationArgumentValues(ASTHelpers.getAnnotationWithSimpleName(classTree.getModifiers().getAnnotations(), "RunWith"), state, "value", ImmutableList.of(junit4 + ".class"))).build()));
                }
                return (Void)super.visitClass(classTree, unused);
            }
        }.scan(tree, null);
        return Description.NO_MATCH;
    }

    private static ImmutableSet<Type> getExtendedTypes(VisitorState state) {
        final ImmutableSet.Builder extendedTypes = ImmutableSet.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitClass(ClassTree classTree, Void unused) {
                if (classTree.getExtendsClause() != null) {
                    extendedTypes.add(ASTHelpers.getType(classTree.getExtendsClause()));
                }
                return (Void)super.visitClass(classTree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return extendedTypes.build();
    }
}

