/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="JavaUtilDate", summary="Date has a bad API that leads to bugs; prefer java.time.Instant or LocalDate.", severity=BugPattern.SeverityLevel.WARNING)
public class JavaUtilDateChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> EXEMPTIONS = Matchers.anyOf(MethodMatchers.instanceMethod().onExactClass("java.util.Date").named("toInstant"), MethodMatchers.staticMethod().onClass("java.util.Date").named("from").withParameters("java.time.Instant", new String[0]));
    private static final Supplier<Type> JAVA_UTIL_DATE = VisitorState.memoize(state -> state.getTypeFromString("java.util.Date"));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!JavaUtilDateChecker.isDate(state, ASTHelpers.getReceiverType(tree))) {
            return Description.NO_MATCH;
        }
        if (EXEMPTIONS.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return JavaUtilDateChecker.isDate(state, ASTHelpers.getType(tree.getIdentifier())) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    private static boolean isDate(VisitorState state, Type type) {
        return ASTHelpers.isSameType(type, JAVA_UTIL_DATE.get(state), state);
    }
}

