/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Instead of converting enums to string and back, its numeric value should be used instead as it is the stable part of the protocol defined by the enum.", severity=BugPattern.SeverityLevel.WARNING)
public class LiteEnumValueOf
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> PROTO_MSG_VALUE_OF_MATCHER = Matchers.staticMethod().onClass(TypePredicates.allOf(TypePredicates.isDescendantOf("com.google.protobuf.Internal.EnumLite"), TypePredicates.not(TypePredicates.isDescendantOf("com.google.protobuf.ProtocolMessageEnum")), TypePredicates.not(TypePredicates.isDescendantOf("com.google.protobuf.AbstractMessageLite.InternalOneOfEnum")))).named("valueOf").withParameters("java.lang.String", new String[0]);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!PROTO_MSG_VALUE_OF_MATCHER.matches(methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.getGeneratedBy(state).contains("com.ryanharter.auto.value.parcel.AutoValueParcelExtension")) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(methodInvocationTree);
    }
}

