/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.WhileLoopTree;

@BugPattern(summary="Assignment where a boolean expression was expected; use == if this assignment wasn't expected or add parentheses for clarity.", severity=BugPattern.SeverityLevel.WARNING, tags={"LikelyError"})
public class LogicalAssignment
extends BugChecker
implements BugChecker.IfTreeMatcher,
BugChecker.WhileLoopTreeMatcher,
BugChecker.DoWhileLoopTreeMatcher,
BugChecker.ForLoopTreeMatcher {
    @Override
    public Description matchIf(IfTree tree, VisitorState state) {
        return this.checkCondition(LogicalAssignment.skipOneParen(tree.getCondition()), state);
    }

    @Override
    public Description matchDoWhileLoop(DoWhileLoopTree tree, VisitorState state) {
        return this.checkCondition(LogicalAssignment.skipOneParen(tree.getCondition()), state);
    }

    @Override
    public Description matchForLoop(ForLoopTree tree, VisitorState state) {
        return this.checkCondition(tree.getCondition(), state);
    }

    @Override
    public Description matchWhileLoop(WhileLoopTree tree, VisitorState state) {
        return this.checkCondition(LogicalAssignment.skipOneParen(tree.getCondition()), state);
    }

    private static ExpressionTree skipOneParen(ExpressionTree tree) {
        return tree instanceof ParenthesizedTree ? ((ParenthesizedTree)tree).getExpression() : tree;
    }

    private Description checkCondition(ExpressionTree condition, VisitorState state) {
        if (!(condition instanceof AssignmentTree)) {
            return Description.NO_MATCH;
        }
        AssignmentTree assign = (AssignmentTree)condition;
        return this.buildDescription(condition).addFix(SuggestedFix.builder().prefixWith(condition, "(").postfixWith(condition, ")").build()).addFix(SuggestedFix.replace(state.getEndPosition(assign.getVariable()), ASTHelpers.getStartPosition(assign.getExpression()), " == ")).build();
    }
}

