/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Math.abs does not always give a positive result. Please consider other methods for positive random numbers.", severity=BugPattern.SeverityLevel.WARNING)
public class MathAbsoluteRandom
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> RANDOM_ABS_VAL = Matchers.allOf(Matchers.staticMethod().onClass("java.lang.Math").named("abs"), Matchers.argument(0, Matchers.instanceMethod().onDescendantOf("java.util.Random").namedAnyOf("nextInt", "nextLong").withNoParameters()));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (RANDOM_ABS_VAL.matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

