/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;

@BugPattern(summary="Math.round(Integer) results in truncation", explanation="Math.round() called with an integer or long type results in truncation because Math.round only accepts floats or doubles and some integers and longs can't be represented with float.", severity=BugPattern.SeverityLevel.ERROR)
public final class MathRoundIntLong
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATH_ROUND_CALLS = Matchers.staticMethod().onClass("java.lang.Math").named("round");
    private static final Matcher<MethodInvocationTree> ROUND_CALLS_WITH_INT_ARG = Matchers.allOf(MATH_ROUND_CALLS, Matchers.argument(0, Matchers.anyOf(Matchers.isSameType("int"), Matchers.isSameType("java.lang.Integer"))));
    private static final Matcher<MethodInvocationTree> ROUND_CALLS_WITH_LONG_ARG = Matchers.allOf(MATH_ROUND_CALLS, Matchers.argument(0, Matchers.anyOf(Matchers.isSameType("long"), Matchers.isSameType("java.lang.Long"))));
    private static final Matcher<MethodInvocationTree> ROUND_CALLS_WITH_INT_OR_LONG_ARG = Matchers.anyOf(ROUND_CALLS_WITH_INT_ARG, ROUND_CALLS_WITH_LONG_ARG);

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return ROUND_CALLS_WITH_INT_OR_LONG_ARG.matches(tree, state) ? this.removeMathRoundCall(tree, state) : Description.NO_MATCH;
    }

    private Description removeMathRoundCall(MethodInvocationTree tree, VisitorState state) {
        if (ROUND_CALLS_WITH_INT_ARG.matches(tree, state)) {
            if (ASTHelpers.requiresParentheses(Iterables.getOnlyElement(tree.getArguments()), state)) {
                return this.describeMatch(tree, (Fix)SuggestedFix.builder().prefixWith(tree, "(").replace(tree, state.getSourceForNode(tree.getArguments().get(0))).postfixWith(tree, ")").build());
            }
            return this.describeMatch(tree, (Fix)SuggestedFix.replace(tree, state.getSourceForNode(tree.getArguments().get(0))));
        }
        if (ROUND_CALLS_WITH_LONG_ARG.matches(tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.builder().addImport("com.google.common.primitives.Ints").prefixWith(tree, "Ints.saturatedCast(").replace(tree, state.getSourceForNode(tree.getArguments().get(0))).postfixWith(tree, ")").build());
        }
        throw new AssertionError((Object)("Unknown argument type to round call: " + state.getSourceForNode(tree)));
    }
}

