/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.Modifier;

@BugPattern(summary="method overrides method in supertype; expected @Override", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"})
public class MissingOverride
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private final boolean ignoreInterfaceOverrides;

    public MissingOverride(ErrorProneFlags flags) {
        this.ignoreInterfaceOverrides = flags.getBoolean("MissingOverride:IgnoreInterfaceOverrides").orElse(false);
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        if (sym.isStatic()) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Symbol)sym, Override.class, state)) {
            return Description.NO_MATCH;
        }
        if (this.ignoreInterfaceOverrides && sym.enclClass().isInterface()) {
            return Description.NO_MATCH;
        }
        return ASTHelpers.streamSuperMethods(sym, state.getTypes()).findFirst().filter(unused -> ASTHelpers.getGeneratedBy(state).isEmpty()).filter(override -> !ASTHelpers.hasAnnotation((Symbol)override, Deprecated.class, state)).map(override -> this.buildDescription(tree).addFix(SuggestedFix.prefixWith(tree, "@Override ")).setMessage(String.format("%s %s method in %s; expected @Override", sym.getSimpleName(), override.enclClass().isInterface() || override.getModifiers().contains((Object)Modifier.ABSTRACT) ? "implements" : "overrides", override.enclClass().getSimpleName())).build()).orElse(Description.NO_MATCH);
    }
}

