/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_MissingTestCall_MethodPairing;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

@BugPattern(summary="A terminating method call is required for a test helper to have any effect.", severity=BugPattern.SeverityLevel.ERROR)
public final class MissingTestCall
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final ImmutableSet<MethodPairing> PAIRINGS = ImmutableSet.of(MethodPairing.of("EqualsTester", MethodMatchers.instanceMethod().onDescendantOf("com.google.common.testing.EqualsTester").named("addEqualityGroup"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.testing.EqualsTester").named("testEquals")), MethodPairing.of("BugCheckerRefactoringTestHelper", MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper").namedAnyOf("addInput", "addInputLines", "addInputFile", "addOutput", "addOutputLines", "addOutputFile", "expectUnchanged"), MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.BugCheckerRefactoringTestHelper").named("doTest")), MethodPairing.of("CompilationTestHelper", MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper").namedAnyOf("addSourceLines", "addSourceFile", "expectNoDiagnostics"), MethodMatchers.instanceMethod().onDescendantOf("com.google.errorprone.CompilationTestHelper").named("doTest")));

    @Override
    public Description matchMethod(MethodTree tree, final VisitorState state) {
        final ImmutableSet<MethodPairing> pairings = PAIRINGS;
        final HashSet required = new HashSet();
        final HashSet called = new HashSet();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree node, Void unused) {
                for (MethodPairing pairing : pairings) {
                    VisitorState stateWithPath = state.withPath(this.getCurrentPath());
                    if (pairing.ifCall().matches(node, stateWithPath) && !MissingTestCall.isField(MissingTestCall.getUltimateReceiver(node)) && stateWithPath.findPathToEnclosing(ReturnTree.class) == null) {
                        required.add(pairing);
                    }
                    if (!pairing.mustCall().matches(node, stateWithPath)) continue;
                    called.add(pairing);
                }
                return (Void)super.visitMethodInvocation(node, null);
            }
        }.scan(state.getPath(), (Void)null);
        return Sets.difference(required, called).stream().findFirst().map(p -> this.buildDescription(tree).setMessage(String.format("%s requires a terminating method call to have any effect.", p.name())).build()).orElse(Description.NO_MATCH);
    }

    @Nullable
    private static ExpressionTree getUltimateReceiver(ExpressionTree tree) {
        return Streams.findLast(ASTHelpers.streamReceivers(tree)).orElse(null);
    }

    private static boolean isField(@Nullable ExpressionTree tree) {
        if (!(tree instanceof IdentifierTree)) {
            return false;
        }
        Symbol symbol = ASTHelpers.getSymbol(tree);
        return symbol != null && symbol.getKind() == ElementKind.FIELD;
    }

    @AutoValue
    static abstract class MethodPairing {
        MethodPairing() {
        }

        abstract String name();

        abstract Matcher<ExpressionTree> ifCall();

        abstract Matcher<ExpressionTree> mustCall();

        private static MethodPairing of(String name, Matcher<ExpressionTree> ifCall, Matcher<ExpressionTree> mustCall) {
            return new AutoValue_MissingTestCall_MethodPairing(name, ifCall, mustCall);
        }
    }
}

