/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;

@BugPattern(severity=BugPattern.SeverityLevel.WARNING, summary="This mock is instantiated and configured, but is never passed to production code. It should be either removed or used.")
public final class MockNotUsedInProduction
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    private static final Matcher<ExpressionTree> MOCK = Matchers.anyOf(Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf("mock").withParameters("java.lang.Class", new String[0]), Matchers.staticMethod().onClass("org.mockito.Mockito").namedAnyOf("spy"));
    private static final Matcher<VariableTree> MOCK_OR_SPY_ANNOTATED = Matchers.anyOf(Matchers.hasAnnotation("org.mockito.Mock"), Matchers.hasAnnotation("org.mockito.Spy"));
    private static final Matcher<VariableTree> INJECT_MOCKS_ANNOTATED = Matchers.hasAnnotation("org.mockito.InjectMocks");
    private static final Matcher<ExpressionTree> WHEN_OR_VERIFY = Matchers.anyMethod().anyClass().namedAnyOf("when", "verify");

    @Override
    public Description matchCompilationUnit(CompilationUnitTree tree, final VisitorState state) {
        ImmutableMap<Symbol.VarSymbol, Tree> mocks = this.findMocks(state);
        if (mocks.isEmpty()) {
            return Description.NO_MATCH;
        }
        final HashSet usedMocks = new HashSet();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree invocation, Void unused) {
                if (WHEN_OR_VERIFY.matches(invocation, state)) {
                    this.scan(invocation.getMethodSelect(), null);
                    return null;
                }
                return (Void)super.visitMethodInvocation(invocation, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree memberSelect, Void unused) {
                this.handle(memberSelect);
                return (Void)super.visitMemberSelect(memberSelect, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifier, Void unused) {
                this.handle(identifier);
                return (Void)super.visitIdentifier(identifier, null);
            }

            private void handle(Tree tree) {
                Symbol symbol = ASTHelpers.getSymbol(tree);
                if (symbol instanceof Symbol.VarSymbol) {
                    usedMocks.add((Symbol.VarSymbol)symbol);
                }
            }
        }.scan(state.getPath(), (Void)null);
        mocks.forEach((sym, mockTree) -> {
            if (usedMocks.contains(sym)) {
                return;
            }
            state.reportMatch(this.describeMatch((Tree)mockTree, (Fix)MockNotUsedInProduction.generateFix(sym, state)));
        });
        return Description.NO_MATCH;
    }

    private static SuggestedFix generateFix(final Symbol.VarSymbol sym, VisitorState state) {
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                if (Objects.equals(ASTHelpers.getSymbol(tree), sym)) {
                    Stream.concat(Stream.of(tree), Streams.stream(this.getCurrentPath())).filter(t -> t instanceof ExpressionStatementTree || t instanceof VariableTree).findFirst().ifPresent(fix::delete);
                }
                return (Void)super.scan(tree, null);
            }
        }.scan((Tree)state.getPath().getCompilationUnit(), null);
        return fix.build();
    }

    private ImmutableMap<Symbol.VarSymbol, Tree> findMocks(final VisitorState state) {
        final HashMap mocks = new HashMap();
        final AtomicBoolean injectMocks = new AtomicBoolean(false);
        new BugChecker.SuppressibleTreePathScanner<Void, Void>(state){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
                if (INJECT_MOCKS_ANNOTATED.matches(tree, state)) {
                    injectMocks.set(true);
                }
                if (this.isEligible(symbol) && (MOCK_OR_SPY_ANNOTATED.matches(tree, state) || tree.getInitializer() != null && MOCK.matches(tree.getInitializer(), state))) {
                    mocks.put(symbol, tree);
                }
                return (Void)super.visitVariable(tree, null);
            }

            @Override
            public Void visitAssignment(AssignmentTree tree, Void unused) {
                Symbol symbol;
                if (MOCK.matches(tree.getExpression(), state) && this.isEligible(symbol = ASTHelpers.getSymbol(tree.getVariable()))) {
                    mocks.put((Symbol.VarSymbol)symbol, tree);
                }
                return (Void)super.visitAssignment(tree, null);
            }

            private boolean isEligible(Symbol symbol) {
                return symbol instanceof Symbol.VarSymbol && (!symbol.getKind().equals((Object)ElementKind.FIELD) || ASTHelpers.canBeRemoved((Symbol.VarSymbol)symbol)) && this.annotatedAtMostMock(symbol);
            }

            private boolean annotatedAtMostMock(Symbol symbol) {
                return symbol.getAnnotationMirrors().stream().allMatch(a -> a.getAnnotationType().asElement().getSimpleName().contentEquals("Mock"));
            }
        }.scan((Tree)state.getPath().getCompilationUnit(), null);
        return injectMocks.get() ? ImmutableMap.of() : ImmutableMap.copyOf(mocks);
    }
}

