/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Name;
import java.util.List;

@BugPattern(summary="Missing method call for verify(mock) here", severity=BugPattern.SeverityLevel.ERROR)
public class MockitoUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MOCK_METHOD = Matchers.anyOf(MethodMatchers.staticMethod().onClass("org.mockito.Mockito").withSignature("<T>when(T)"), MethodMatchers.staticMethod().onClass("org.mockito.Mockito").withSignature("<T>verify(T)"), MethodMatchers.staticMethod().onClass("org.mockito.Mockito").withSignature("<T>verify(T,org.mockito.verification.VerificationMode)"));
    private static final Matcher<ExpressionTree> NEVER_METHOD = MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("never").withNoParameters();

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MOCK_METHOD.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (state.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return Description.NO_MATCH;
        }
        String message = String.format("Missing method call for %s here", state.getSourceForNode(tree));
        Description.Builder builder = this.buildDescription(tree).setMessage(message);
        MockitoUsage.buildFix(builder, tree, state);
        return builder.build();
    }

    private static void buildFix(Description.Builder builder, MethodInvocationTree tree, VisitorState state) {
        Tree parent;
        MethodInvocationTree mockitoCall = tree;
        List<? extends ExpressionTree> args = mockitoCall.getArguments();
        Tree mock = mockitoCall.getArguments().get(0);
        boolean isVerify = ((Name)ASTHelpers.getSymbol(tree).getSimpleName()).contentEquals("verify");
        if (isVerify && mock.getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree invocation = (MethodInvocationTree)mock;
            String verify = state.getSourceForNode(mockitoCall.getMethodSelect());
            String receiver = state.getSourceForNode(ASTHelpers.getReceiver(invocation));
            String mode = args.size() > 1 ? ", " + state.getSourceForNode(args.get(1)) : "";
            String call = state.getSourceForNode(invocation).substring(receiver.length());
            builder.addFix(SuggestedFix.replace(tree, String.format("%s(%s%s)%s", verify, receiver, mode, call)));
        }
        if (isVerify && args.size() > 1 && NEVER_METHOD.matches(args.get(1), state)) {
            builder.addFix(SuggestedFix.builder().addStaticImport("org.mockito.Mockito.verifyZeroInteractions").replace(tree, String.format("verifyZeroInteractions(%s)", state.getSourceForNode(mock))).build());
        }
        if ((parent = state.getPath().getParentPath().getLeaf()).getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            builder.addFix(SuggestedFix.delete(parent));
        } else {
            builder.addFix(SuggestedFix.delete(tree));
        }
    }
}

