/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.IsSubtypeOf;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.type.DescendantOf;
import com.google.errorprone.predicates.type.DescendantOfAny;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.SideEffectAnalysis;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@BugPattern(summary="A collection or proto builder was created, but its values were never accessed.", severity=BugPattern.SeverityLevel.WARNING)
public class ModifiedButNotUsed
extends BugChecker
implements BugChecker.ExpressionStatementTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final ImmutableSet<String> GUAVA_IMMUTABLES = ImmutableSet.of("com.google.common.collect.ImmutableCollection", "com.google.common.collect.ImmutableMap", "com.google.common.collect.ImmutableMultimap");
    private static final ImmutableSet<String> COLLECTIONS = Streams.concat(GUAVA_IMMUTABLES.stream().map(i -> i + ".Builder"), Stream.of("java.util.Collection", "java.util.Map", "com.google.common.collect.Multimap")).collect(ImmutableSet.toImmutableSet());
    private static final Matcher<ExpressionTree> COLLECTION_SETTER = MethodMatchers.instanceMethod().onDescendantOfAny(COLLECTIONS).namedAnyOf("add", "addAll", "clear", "put", "putAll", "remove", "removeAll", "removeIf", "replaceAll", "retainAll", "set", "sort");
    private static final String MESSAGE = "com.google.protobuf.MessageLite";
    private static final String MESSAGE_BUILDER = "com.google.protobuf.MessageLite.Builder";
    static final Matcher<ExpressionTree> FLUENT_SETTER = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").withNameMatching(Pattern.compile("(add|clear|merge|remove|set|put).*")), MethodMatchers.instanceMethod().onDescendantOfAny(GUAVA_IMMUTABLES.stream().map(c -> c + ".Builder").collect(ImmutableSet.toImmutableSet())).namedAnyOf("add", "addAll", "put", "putAll"));
    private static final Matcher<ExpressionTree> FLUENT_CHAIN = Matchers.anyOf(FLUENT_SETTER, MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").withNameMatching(Pattern.compile("get.+")));
    private static final Matcher<Tree> COLLECTION_TYPE = Matchers.anyOf(COLLECTIONS.stream().map(IsSubtypeOf::new).collect(ImmutableList.toImmutableList()));
    private static final Matcher<Tree> PROTO_TYPE = new IsSubtypeOf<Tree>("com.google.protobuf.MessageLite.Builder");
    private static final Matcher<ExpressionTree> FLUENT_CONSTRUCTOR = Matchers.anyOf(Matchers.allOf(Matchers.kindIs(Tree.Kind.NEW_CLASS), MethodMatchers.constructor().forClass(new DescendantOfAny(GUAVA_IMMUTABLES.stream().map(i -> Suppliers.typeFromString(i + ".Builder")).collect(ImmutableList.toImmutableList())))), Matchers.staticMethod().onDescendantOfAny(GUAVA_IMMUTABLES).namedAnyOf("builder", "builderWithExpectedSize"), Matchers.allOf(Matchers.kindIs(Tree.Kind.NEW_CLASS), MethodMatchers.constructor().forClass(new DescendantOf(Suppliers.typeFromString("com.google.protobuf.MessageLite.Builder")))), Matchers.staticMethod().onDescendantOf("com.google.protobuf.MessageLite").named("newBuilder"), MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite").namedAnyOf("toBuilder", "newBuilderForType"));
    private static final Matcher<ExpressionTree> NEW_COLLECTION = Matchers.anyOf(MethodMatchers.constructor().forClass(new DescendantOfAny(COLLECTIONS.stream().map(Suppliers::typeFromString).collect(ImmutableList.toImmutableList()))), Matchers.staticMethod().onClassAny("com.google.common.collect.Lists", "com.google.common.collect.Maps", "com.google.common.collect.Sets").withNameMatching(Pattern.compile("new.+")));
    private static final Matcher<ExpressionTree> BUILD_CALL = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("com.google.protobuf.MessageLite.Builder").namedAnyOf("build", "buildPartial"), MethodMatchers.instanceMethod().onDescendantOfAny(GUAVA_IMMUTABLES.stream().map(c -> c + ".Builder").collect(ImmutableList.toImmutableList())).named("build"));

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        final Symbol.VarSymbol symbol = ASTHelpers.getSymbol(tree);
        if (!ASTHelpers.isConsideredFinal(symbol)) {
            return Description.NO_MATCH;
        }
        if (state.getPath().getParentPath().getLeaf() instanceof ClassTree) {
            return Description.NO_MATCH;
        }
        if (!COLLECTION_TYPE.matches(tree, state) && !PROTO_TYPE.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        final ArrayList<TreePath> initializers = new ArrayList<TreePath>();
        if (tree.getInitializer() == null) {
            new TreePathScanner<Void, Void>(){

                @Override
                public Void visitAssignment(AssignmentTree node, Void unused) {
                    if (symbol.equals(ASTHelpers.getSymbol(node.getVariable()))) {
                        initializers.add(new TreePath(this.getCurrentPath(), node.getExpression()));
                    }
                    return (Void)super.visitAssignment(node, unused);
                }
            }.scan(state.getPath().getParentPath(), (Void)null);
        } else {
            initializers.add(new TreePath(state.getPath(), tree.getInitializer()));
        }
        if (initializers.size() != 1) {
            return Description.NO_MATCH;
        }
        TreePath initializerPath = (TreePath)Iterables.getOnlyElement(initializers);
        ExpressionTree initializer = (ExpressionTree)initializerPath.getLeaf();
        if (!NEW_COLLECTION.matches(initializer, state) && !ModifiedButNotUsed.newFluentChain(initializer, state)) {
            return Description.NO_MATCH;
        }
        UnusedScanner isUnusedScanner = new UnusedScanner(symbol, state, ModifiedButNotUsed.getMatcher(tree, state));
        isUnusedScanner.scan(state.getPath().getParentPath(), null);
        if (isUnusedScanner.isUsed) {
            return Description.NO_MATCH;
        }
        ImmutableList<TreePath> removals = tree.getInitializer() == null ? ImmutableList.of(state.getPath(), initializerPath) : ImmutableList.of(initializerPath);
        return this.buildDescription(initializer).addAllFixes(isUnusedScanner.buildFixes(removals)).build();
    }

    private static Matcher<IdentifierTree> getMatcher(Tree tree, VisitorState state) {
        return COLLECTION_TYPE.matches(tree, state) ? (t, s) -> ModifiedButNotUsed.collectionUsed(s) : (t, s) -> ModifiedButNotUsed.fluentBuilderUsed(s);
    }

    private static boolean collectionUsed(VisitorState state) {
        TreePath path = state.getPath();
        return !(path.getParentPath().getLeaf() instanceof MemberSelectTree) || !(path.getParentPath().getParentPath().getLeaf() instanceof MethodInvocationTree) || !COLLECTION_SETTER.matches((MethodInvocationTree)path.getParentPath().getParentPath().getLeaf(), state) || ASTHelpers.targetType(state.withPath(path.getParentPath().getParentPath())) != null;
    }

    private static boolean fluentBuilderUsed(VisitorState state) {
        TreePath path = state.getPath();
        while (path != null) {
            if (path.getParentPath().getLeaf() instanceof ExpressionStatementTree) {
                return false;
            }
            if (!(path.getParentPath().getLeaf() instanceof MemberSelectTree && path.getParentPath().getParentPath().getLeaf() instanceof MethodInvocationTree && FLUENT_CHAIN.matches((MethodInvocationTree)path.getParentPath().getParentPath().getLeaf(), state))) {
                return true;
            }
            path = path.getParentPath().getParentPath();
        }
        return true;
    }

    @Override
    public Description matchExpressionStatement(ExpressionStatementTree tree, VisitorState state) {
        ExpressionTree expression = tree.getExpression();
        if (BUILD_CALL.matches(expression, state)) {
            expression = ASTHelpers.getReceiver(expression);
        }
        if (expression == null) {
            return Description.NO_MATCH;
        }
        if (!FLUENT_SETTER.matches(expression, state)) {
            return Description.NO_MATCH;
        }
        if (!ModifiedButNotUsed.newFluentChain(expression, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Modifying a Builder without assigning it to anything does nothing.").build();
    }

    private static boolean newFluentChain(ExpressionTree tree, VisitorState state) {
        return Streams.concat(Stream.of(tree), ASTHelpers.streamReceivers(tree)).filter(t -> !FLUENT_CHAIN.matches((ExpressionTree)t, state)).findFirst().map(t -> FLUENT_CONSTRUCTOR.matches((ExpressionTree)t, state)).orElse(false);
    }

    private static class UnusedScanner
    extends TreePathScanner<Void, Void> {
        private final Symbol symbol;
        private final VisitorState state;
        private final Matcher<IdentifierTree> matcher;
        private final List<TreePath> usageSites = new ArrayList<TreePath>();
        private boolean isUsed = false;

        private UnusedScanner(Symbol symbol, VisitorState state, Matcher<IdentifierTree> matcher) {
            this.symbol = symbol;
            this.state = state;
            this.matcher = matcher;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
            if (!Objects.equals(ASTHelpers.getSymbol(identifierTree), this.symbol)) {
                return null;
            }
            if (this.matcher.matches(identifierTree, this.state.withPath(this.getCurrentPath()))) {
                this.isUsed = true;
                return null;
            }
            this.usageSites.add(this.getCurrentPath());
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Void unused) {
            if (Objects.equals(ASTHelpers.getSymbol(variableTree), this.symbol)) {
                return null;
            }
            return (Void)super.visitVariable(variableTree, null);
        }

        @Override
        public Void visitAssignment(AssignmentTree assignmentTree, Void unused) {
            if (Objects.equals(ASTHelpers.getSymbol(assignmentTree.getVariable()), this.symbol)) {
                return (Void)this.scan(assignmentTree.getExpression(), null);
            }
            return (Void)super.visitAssignment(assignmentTree, null);
        }

        private ImmutableList<SuggestedFix> buildFixes(List<TreePath> removals) {
            boolean encounteredSideEffects = false;
            SuggestedFix.Builder withoutSideEffects = SuggestedFix.builder().setShortDescription("remove unused variable and any side effects");
            SuggestedFix.Builder withSideEffects = SuggestedFix.builder().setShortDescription("remove unused variable");
            for (TreePath usageSite : Iterables.concat(removals, this.usageSites)) {
                ArrayList keepingSideEffects = new ArrayList();
                TreePath path = usageSite;
                while (!(path.getLeaf() instanceof StatementTree)) {
                    block9: {
                        List<? extends ExpressionTree> arguments;
                        block8: {
                            block7: {
                                if (!(path.getLeaf() instanceof MethodInvocationTree)) break block7;
                                arguments = ((MethodInvocationTree)path.getLeaf()).getArguments();
                                break block8;
                            }
                            if (!(path.getLeaf() instanceof NewClassTree)) break block9;
                            arguments = ((NewClassTree)path.getLeaf()).getArguments();
                        }
                        arguments.stream().filter(SideEffectAnalysis::hasSideEffect).map(e -> this.state.getSourceForNode((Tree)e) + ";").forEach(keepingSideEffects::add);
                    }
                    path = path.getParentPath();
                }
                StatementTree enclosingStatement = (StatementTree)this.state.withPath(usageSite).findEnclosing(StatementTree.class);
                if (!keepingSideEffects.isEmpty()) {
                    encounteredSideEffects = true;
                    withSideEffects.replace(enclosingStatement, keepingSideEffects.stream().collect(Collectors.joining("")));
                } else {
                    withSideEffects.replace(enclosingStatement, "");
                }
                withoutSideEffects.replace(enclosingStatement, "");
            }
            return encounteredSideEffects ? ImmutableList.of(withoutSideEffects.build(), withSideEffects.build()) : ImmutableList.of(withoutSideEffects.build());
        }
    }
}

