/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.annotation.Nullable;

@BugPattern(summary="Modifying the backing source during stream operations may cause unintended results.", severity=BugPattern.SeverityLevel.WARNING)
public class ModifySourceCollectionInStream
extends BugChecker
implements BugChecker.MemberReferenceTreeMatcher,
BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableList<String> STATE_MUTATION_METHOD_NAMES = ImmutableList.of("add", "addAll", "clear", "remove", "removeAll", "retainAll");
    private static final ImmutableList<String> STREAM_CREATION_METHOD_NAMES = ImmutableList.of("stream", "parallelStream");
    private static final Matcher<ExpressionTree> COLLECTION_TO_STREAM_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").namedAnyOf(STREAM_CREATION_METHOD_NAMES);
    private static final Matcher<ExpressionTree> STREAM_API_INVOCATION_MATCHER = MethodMatchers.instanceMethod().onDescendantOfAny("java.util.stream.BaseStream");
    private static final Matcher<ExpressionTree> MUTATION_METHOD_MATCHER = MethodMatchers.instanceMethod().onDescendantOf("java.util.Collection").namedAnyOf(STATE_MUTATION_METHOD_NAMES);

    @Override
    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (!Matchers.isSubtypeOf("java.util.Collection").matches(tree.getQualifierExpression(), state) || STATE_MUTATION_METHOD_NAMES.stream().noneMatch(methodName -> methodName.contentEquals(tree.getName()))) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)state.findEnclosing(MethodInvocationTree.class);
        return ModifySourceCollectionInStream.isStreamApiInvocationOnStreamSource(methodInvocationTree, ASTHelpers.getReceiver(tree), state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!MUTATION_METHOD_MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree mutatedReceiver = ASTHelpers.getReceiver(tree);
        if (mutatedReceiver == null) {
            return Description.NO_MATCH;
        }
        TreePath pathToLambdaExpression = state.findPathToEnclosing(LambdaExpressionTree.class);
        if (pathToLambdaExpression == null) {
            return Description.NO_MATCH;
        }
        Tree parentNode = pathToLambdaExpression.getParentPath().getLeaf();
        if (!(parentNode instanceof ExpressionTree)) {
            return Description.NO_MATCH;
        }
        return ModifySourceCollectionInStream.isStreamApiInvocationOnStreamSource((ExpressionTree)parentNode, mutatedReceiver, state) ? this.describeMatch(tree) : Description.NO_MATCH;
    }

    private static boolean isStreamApiInvocationOnStreamSource(@Nullable ExpressionTree rootTree, ExpressionTree streamSourceExpression, VisitorState visitorState) {
        ExpressionTree expressionTree = rootTree;
        while (STREAM_API_INVOCATION_MATCHER.matches(expressionTree, visitorState)) {
            expressionTree = ASTHelpers.getReceiver(expressionTree);
        }
        if (!COLLECTION_TO_STREAM_MATCHER.matches(expressionTree, visitorState)) {
            return false;
        }
        return ModifySourceCollectionInStream.isSameExpression(ASTHelpers.getReceiver(expressionTree), streamSourceExpression);
    }

    private static boolean isSameExpression(ExpressionTree leftTree, ExpressionTree rightTree) {
        if (ASTHelpers.getSymbol(leftTree) != ASTHelpers.getSymbol(rightTree)) {
            return false;
        }
        String leftTreeTextRepr = ModifySourceCollectionInStream.stripPrefixIfPresent(leftTree.toString(), "this.");
        String rightTreeTextRepr = ModifySourceCollectionInStream.stripPrefixIfPresent(rightTree.toString(), "this.");
        return leftTreeTextRepr.contentEquals(rightTreeTextRepr);
    }

    private static String stripPrefixIfPresent(String originalText, String prefix) {
        return originalText.startsWith(prefix) ? originalText.substring(prefix.length()) : originalText;
    }
}

