/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.bugpatterns.AbstractMustBeClosedChecker;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import java.util.List;

@BugPattern(altNames={"MustBeClosed"}, summary="This method returns a resource which must be managed carefully, not just left for garbage collection. If it is a constant that will persist for the lifetime of your program, move it to a private static final field. Otherwise, you should use it in a try-with-resources.", severity=BugPattern.SeverityLevel.ERROR)
public class MustBeClosedChecker
extends AbstractMustBeClosedChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.ClassTreeMatcher {
    private final boolean findingPerSite;
    private static final Matcher<Tree> IS_AUTOCLOSEABLE = Matchers.isSubtypeOf(AutoCloseable.class);
    private static final Matcher<MethodTree> METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER = Matchers.allOf(Matchers.not(Matchers.methodIsConstructor()), Matchers.methodReturns(IS_AUTOCLOSEABLE));
    private static final Matcher<MethodTree> AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER = Matchers.allOf(Matchers.methodIsConstructor(), Matchers.enclosingClass(Matchers.isSubtypeOf(AutoCloseable.class)));
    private static final Matcher<ExpressionTree> CONSTRUCTOR = MethodMatchers.constructor();

    public MustBeClosedChecker() {
        this.findingPerSite = true;
    }

    public MustBeClosedChecker(ErrorProneFlags flags) {
        this.findingPerSite = flags.getBoolean("MustBeClosedChecker:FindingPerMethod").orElse(false) == false;
    }

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        boolean isAConstructor = Matchers.methodIsConstructor().matches(tree, state);
        if (isAConstructor && !AUTO_CLOSEABLE_CONSTRUCTOR_MATCHER.matches(tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate constructors of AutoCloseables.").build();
        }
        if (!isAConstructor && !METHOD_RETURNS_AUTO_CLOSEABLE_MATCHER.matches(tree, state)) {
            return this.buildDescription(tree).setMessage("MustBeClosed should only annotate methods that return an AutoCloseable.").build();
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!this.findingPerSite) {
            return Description.NO_MATCH;
        }
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        if (CONSTRUCTOR.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state, this.findingPerSite());
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!this.findingPerSite) {
            return Description.NO_MATCH;
        }
        if (!HAS_MUST_BE_CLOSED_ANNOTATION.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.matchNewClassOrMethodInvocation(tree, state, this.findingPerSite());
    }

    @Override
    protected Description matchNewClassOrMethodInvocation(ExpressionTree tree, VisitorState state, AbstractMustBeClosedChecker.FixAggregator aggregator) {
        Description description = super.matchNewClassOrMethodInvocation(tree, state, aggregator);
        if (description.equals(Description.NO_MATCH)) {
            return Description.NO_MATCH;
        }
        return description;
    }

    @Override
    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!IS_AUTOCLOSEABLE.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        for (Tree tree2 : tree.getMembers()) {
            MethodTree methodTree;
            if (!(tree2 instanceof MethodTree) || !ASTHelpers.getSymbol(methodTree = (MethodTree)tree2).isConstructor() || ASTHelpers.hasAnnotation((Tree)methodTree, MustBeClosed.class, state) || !MustBeClosedChecker.invokedConstructorMustBeClosed(state, methodTree)) continue;
            if (ASTHelpers.isGeneratedConstructor(methodTree)) {
                state.reportMatch(this.buildDescription(tree).setMessage("Implicitly invoked constructor is marked @MustBeClosed, so this class must have an explicit constructor with @MustBeClosed also.").build());
                continue;
            }
            SuggestedFix.Builder builder = SuggestedFix.builder();
            String suggestedFixName = SuggestedFixes.qualifyType(state, builder, state.getTypeFromString(MustBeClosed.class.getCanonicalName()));
            SuggestedFix fix = builder.prefixWith(methodTree, "@" + suggestedFixName + " ").build();
            state.reportMatch(this.buildDescription(methodTree).addFix(fix).setMessage("Invoked constructor is marked @MustBeClosed, so this constructor must be marked @MustBeClosed too.").build());
            if (this.findingPerSite) continue;
            state.reportMatch(this.scanEntireMethodFor(HAS_MUST_BE_CLOSED_ANNOTATION, methodTree, state.withPath(TreePath.getPath(state.getPath(), (Tree)methodTree))));
        }
        return Description.NO_MATCH;
    }

    private static boolean invokedConstructorMustBeClosed(VisitorState state, MethodTree methodTree) {
        List<? extends StatementTree> statements = methodTree.getBody().getStatements();
        if (statements.isEmpty()) {
            return false;
        }
        ExpressionStatementTree est = (ExpressionStatementTree)statements.get(0);
        MethodInvocationTree mit = (MethodInvocationTree)est.getExpression();
        Symbol.MethodSymbol invokedConstructorSymbol = ASTHelpers.getSymbol(mit);
        return ASTHelpers.hasAnnotation((Symbol)invokedConstructorSymbol, MustBeClosed.class, state);
    }
}

