/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import javax.lang.model.element.Modifier;

@BugPattern(summary="This update of a volatile variable is non-atomic", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"})
public class NonAtomicVolatileUpdate
extends BugChecker
implements BugChecker.UnaryTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher,
BugChecker.AssignmentTreeMatcher {
    private static final Matcher<UnaryTree> unaryIncrementDecrementMatcher = Matchers.allOf(NonAtomicVolatileUpdate.expressionFromUnaryTree(Matchers.hasModifier(Modifier.VOLATILE)), Matchers.not(Matchers.inSynchronized()), Matchers.anyOf(Matchers.kindIs(Tree.Kind.POSTFIX_INCREMENT), Matchers.kindIs(Tree.Kind.PREFIX_INCREMENT), Matchers.kindIs(Tree.Kind.POSTFIX_DECREMENT), Matchers.kindIs(Tree.Kind.PREFIX_DECREMENT)));
    private static final Matcher<CompoundAssignmentTree> compoundAssignmentIncrementDecrementMatcher = Matchers.allOf(NonAtomicVolatileUpdate.variableFromCompoundAssignmentTree(Matchers.hasModifier(Modifier.VOLATILE)), Matchers.not(Matchers.inSynchronized()), Matchers.anyOf(Matchers.kindIs(Tree.Kind.PLUS_ASSIGNMENT), Matchers.kindIs(Tree.Kind.MINUS_ASSIGNMENT)));

    private static Matcher<UnaryTree> expressionFromUnaryTree(final Matcher<ExpressionTree> exprMatcher) {
        return new Matcher<UnaryTree>(){

            @Override
            public boolean matches(UnaryTree tree, VisitorState state) {
                return exprMatcher.matches(tree.getExpression(), state);
            }
        };
    }

    private static Matcher<CompoundAssignmentTree> variableFromCompoundAssignmentTree(final Matcher<ExpressionTree> exprMatcher) {
        return new Matcher<CompoundAssignmentTree>(){

            @Override
            public boolean matches(CompoundAssignmentTree tree, VisitorState state) {
                return exprMatcher.matches(tree.getVariable(), state);
            }
        };
    }

    private static Matcher<AssignmentTree> variableFromAssignmentTree(final Matcher<ExpressionTree> exprMatcher) {
        return new Matcher<AssignmentTree>(){

            @Override
            public boolean matches(AssignmentTree tree, VisitorState state) {
                return exprMatcher.matches(tree.getVariable(), state);
            }
        };
    }

    @Override
    public Description matchUnary(UnaryTree tree, VisitorState state) {
        if (unaryIncrementDecrementMatcher.matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    @Override
    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        if (compoundAssignmentIncrementDecrementMatcher.matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }

    private static Matcher<AssignmentTree> assignmentIncrementDecrementMatcher(ExpressionTree variable) {
        return Matchers.allOf(NonAtomicVolatileUpdate.variableFromAssignmentTree(Matchers.hasModifier(Modifier.VOLATILE)), Matchers.not(Matchers.inSynchronized()), Matchers.assignment(Matchers.anything(), Matchers.toType(BinaryTree.class, Matchers.allOf(Matchers.anyOf(Matchers.kindIs(Tree.Kind.PLUS), Matchers.kindIs(Tree.Kind.MINUS)), Matchers.binaryTree(Matchers.sameVariable(variable), Matchers.anything())))));
    }

    @Override
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (NonAtomicVolatileUpdate.assignmentIncrementDecrementMatcher(tree.getVariable()).matches(tree, state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

